/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.registry;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.IModuleRegistry;
import org.squiddev.plethora.gameplay.ItemBlockBase;
import org.squiddev.plethora.gameplay.keyboard.ItemKeyboard;
import org.squiddev.plethora.gameplay.modules.BlockManipulator;
import org.squiddev.plethora.gameplay.modules.ItemModule;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.gameplay.modules.TileManipulator;
import org.squiddev.plethora.gameplay.modules.TurtleUpgradeKinetic;
import org.squiddev.plethora.gameplay.neural.ItemNeuralConnector;
import org.squiddev.plethora.gameplay.neural.ItemNeuralInterface;
import org.squiddev.plethora.gameplay.redstone.BlockRedstoneIntegrator;
import org.squiddev.plethora.gameplay.redstone.TileRedstoneIntegrator;

@Mod.EventBusSubscriber(modid="plethora")
public final class Registration {
    public static ItemNeuralInterface itemNeuralInterface;
    public static ItemNeuralConnector itemNeuralConnector;
    public static ItemModule itemModule;
    public static ItemKeyboard itemKeyboard;
    public static BlockManipulator blockManipulator;
    public static BlockRedstoneIntegrator blockRedstoneIntegrator;

    private Registration() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[2];
        blockManipulator = new BlockManipulator();
        blockArray[0] = blockManipulator;
        blockRedstoneIntegrator = new BlockRedstoneIntegrator();
        blockArray[1] = blockRedstoneIntegrator;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
        Registration.registerTiles();
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)blockManipulator);
    }

    private static void registerTiles() {
        GameRegistry.registerTileEntity(TileManipulator.class, (ResourceLocation)Objects.requireNonNull(blockManipulator.getRegistryName()));
        GameRegistry.registerTileEntity(TileRedstoneIntegrator.class, (ResourceLocation)Objects.requireNonNull(blockRedstoneIntegrator.getRegistryName()));
        FMLInterModComms.sendMessage((String)"plethora-core", (String)"blacklistPeripheral", (String)TileManipulator.class.getName());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[6];
        itemNeuralInterface = new ItemNeuralInterface();
        itemArray[0] = itemNeuralInterface;
        itemNeuralConnector = new ItemNeuralConnector();
        itemArray[1] = itemNeuralConnector;
        itemModule = new ItemModule();
        itemArray[2] = itemModule;
        itemKeyboard = new ItemKeyboard();
        itemArray[3] = itemKeyboard;
        itemArray[4] = new ItemBlockBase((Block)blockManipulator);
        itemArray[5] = new ItemBlockBase((Block)blockRedstoneIntegrator);
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
        Registration.registerUpgrades();
    }

    public static void registerUpgrades() {
        ItemStack stack;
        IModuleRegistry registry = PlethoraAPI.instance().moduleRegistry();
        for (int id : PlethoraModules.TURTLE_MODULES) {
            stack = new ItemStack((Item)itemModule, 1, id);
            registry.registerTurtleUpgrade(stack);
        }
        ItemStack kineticStack = new ItemStack((Item)itemModule, 1, 4);
        ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new TurtleUpgradeKinetic(kineticStack, (IModuleHandler)kineticStack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null), kineticStack.func_77977_a() + ".adjective"));
        for (int id : PlethoraModules.POCKET_MODULES) {
            stack = new ItemStack((Item)itemModule, 1, id);
            registry.registerPocketUpgrade(stack);
        }
        PlethoraAPI.instance().moduleRegistry().registerPocketUpgrade(new ItemStack((Item)itemKeyboard));
    }
}

