/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.roost;

import com.timwoodcreates.roost.data.DataChicken;
import com.timwoodcreates.roost.data.DataChickenModded;
import com.timwoodcreates.roost.data.DataChickenVanilla;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.ConstantConverter;
import org.squiddev.plethora.api.converter.DynamicConverter;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;

@Injects(value="roost")
public final class IntegrationRoost {
    public static final ConstantConverter<ItemStack, DataChicken> GET_DATA_CHICKEN_FROM_ITEM = DataChicken::getDataFromStack;
    public static final DynamicConverter<Entity, DataChicken> GET_DATA_CHICKEN_FROM_ENTITY = DataChicken::getDataFromEntity;
    public static final IMetaProvider<DataChicken> META_DATA_CHICKEN = new BasicMetaProvider<DataChicken>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull DataChicken context) {
            return context instanceof DataChickenVanilla || context instanceof DataChickenModded ? Collections.emptyMap() : Collections.singletonMap("roost", Collections.singletonMap("name", context.getName()));
        }

        @Override
        @Nonnull
        public DataChicken getExample() {
            return new DataChicken("vanilla", "entity.Chicken.name");
        }
    };
    public static final IMetaProvider<DataChickenVanilla> META_DATA_CHICKEN_VANILLA = new BasicMetaProvider<DataChickenVanilla>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull DataChickenVanilla context) {
            HashMap<String, String> out = new HashMap<String, String>(2);
            NBTTagCompound nbt = context.buildChickenStack().func_77978_p();
            out.put("name", context.getName());
            if (nbt != null) {
                out.put("type", nbt.func_74779_i("Chicken"));
            }
            return Collections.singletonMap("roost", out);
        }

        @Override
        @Nonnull
        public DataChickenVanilla getExample() {
            return new DataChickenVanilla();
        }
    };
    public static final IMetaProvider<DataChickenModded> META_DATA_CHICKEN_MODDED = new BasicMetaProvider<DataChickenModded>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull DataChickenModded context) {
            NBTTagCompound nbt = context.buildChickenStack().func_77978_p();
            if (nbt == null) {
                return Collections.singletonMap("roost", Collections.singletonMap("name", context.getName()));
            }
            HashMap<String, Object> out = new HashMap<String, Object>(5);
            out.put("name", context.getName());
            out.put("growth", nbt.func_74762_e("Growth"));
            out.put("gain", nbt.func_74762_e("Gain"));
            out.put("strength", nbt.func_74762_e("Strength"));
            out.put("type", nbt.func_74779_i("Chicken"));
            return Collections.singletonMap("roost", out);
        }

        @Override
        @Nullable
        public DataChickenModded getExample() {
            if (!Loader.isModLoaded((String)"chickens")) {
                return null;
            }
            LinkedList chickenList = new LinkedList();
            DataChickenModded.addAllChickens(chickenList);
            if (chickenList.isEmpty()) {
                return null;
            }
            DataChicken chicken = (DataChicken)chickenList.get(0);
            return chicken instanceof DataChickenModded ? (DataChickenModded)chicken : null;
        }
    };

    private IntegrationRoost() {
    }
}

