/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ListDeserializer<T>
implements JsonDeserializer<List<T>> {
    private final Class<T> elementClass;

    public ListDeserializer(Class<T> elementClass) {
        this.elementClass = elementClass;
    }

    public List<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList result = Lists.newArrayListWithExpectedSize((int)array.size());
            for (int i = 0; i < array.size(); ++i) {
                result.add(context.deserialize(array.get(i), this.elementClass));
            }
            return result;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)1);
        result.add(context.deserialize(json, this.elementClass));
        return result;
    }
}

