/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.ore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.utils.Utils;
import thelm.jaopca.ore.OreEntry;
import thelm.jaopca.utils.JAOPCAConfig;

public class OreFinder {
    public static final HashMultimap<String, String> DEFAULT_ORE_SYNONYMS = HashMultimap.create();
    public static final TreeMap<String, String> DEFAULT_EXTRAS = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final TreeMap<String, String> DEFAULT_SECOND_EXTRAS = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final TreeMap<String, String> DEFAULT_THIRD_EXTRAS = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final TreeMap<String, Double> DEFAULT_ENERGY_MODIFIERS = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final TreeMap<String, Double> DEFAULT_RARITIES = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final ArrayList<String> CONTAINING_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Aluminum", "Sulphur", "Chrome", "Cesium", "Wolfram", "Wolframium", "Saltpeter", "Brick"});
    public static final TreeSet<String> SHOULD_BE_GEMS = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final TreeSet<String> SHOULD_BE_DUSTS = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    public static final ArrayList<String> PREFIX_BLACKLIST = Lists.newArrayList();
    public static final HashSet<String> CONFLICT_PRECEDENCE = Sets.newHashSet();

    /*
     * WARNING - void declaration
     */
    public static void findOres() {
        void var9_46;
        JAOPCAApi.LOGGER.debug("Finding ores");
        ArrayList allEntries = Lists.newArrayList();
        LinkedHashSet allOres = Sets.newLinkedHashSet();
        TreeSet<String> ingotOres = OreFinder.getMaterialsWithPrefixes("ore", "ingot");
        ingotOres.removeAll(SHOULD_BE_GEMS);
        ingotOres.removeAll(SHOULD_BE_DUSTS);
        allOres.addAll(ingotOres);
        if (JAOPCAConfig.ingot) {
            block0: for (String string : ingotOres) {
                for (String string2 : CONTAINING_BLACKLIST) {
                    if (!string.contains(string2)) continue;
                    continue block0;
                }
                OreEntry oreEntry2 = new OreEntry(string);
                if (DEFAULT_ORE_SYNONYMS.containsKey((Object)string)) {
                    oreEntry2.setOreNameSynonyms(DEFAULT_ORE_SYNONYMS.get((Object)string));
                }
                if (DEFAULT_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_EXTRAS.get(string))) {
                    oreEntry2.setExtra(DEFAULT_EXTRAS.get(string));
                }
                if (DEFAULT_SECOND_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_SECOND_EXTRAS.get(string))) {
                    oreEntry2.setSecondExtra(DEFAULT_SECOND_EXTRAS.get(string));
                }
                if (DEFAULT_THIRD_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_THIRD_EXTRAS.get(string))) {
                    oreEntry2.setThirdExtra(DEFAULT_THIRD_EXTRAS.get(string));
                }
                if (DEFAULT_ENERGY_MODIFIERS.containsKey(string)) {
                    oreEntry2.setEnergyModifier(DEFAULT_ENERGY_MODIFIERS.get(string));
                }
                allEntries.add(oreEntry2);
                JAOPCAApi.LOGGER.debug("Found ingot ore " + string);
            }
        }
        TreeSet<String> gemOres = OreFinder.getMaterialsWithPrefixes("ore", "gem");
        gemOres.removeAll(SHOULD_BE_DUSTS);
        gemOres.removeAll(allOres);
        allOres.addAll(gemOres);
        if (JAOPCAConfig.gem) {
            block2: for (String string : gemOres) {
                for (String string3 : CONTAINING_BLACKLIST) {
                    if (!string.contains(string3)) continue;
                    continue block2;
                }
                OreEntry oreEntry3 = new OreEntry(string);
                oreEntry3.setOreType(EnumOreType.GEM);
                if (DEFAULT_ORE_SYNONYMS.containsKey((Object)string)) {
                    oreEntry3.setOreNameSynonyms(DEFAULT_ORE_SYNONYMS.get((Object)string));
                }
                if (DEFAULT_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_EXTRAS.get(string))) {
                    oreEntry3.setExtra(DEFAULT_EXTRAS.get(string));
                }
                if (DEFAULT_SECOND_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_SECOND_EXTRAS.get(string))) {
                    oreEntry3.setSecondExtra(DEFAULT_SECOND_EXTRAS.get(string));
                }
                if (DEFAULT_THIRD_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_THIRD_EXTRAS.get(string))) {
                    oreEntry3.setThirdExtra(DEFAULT_THIRD_EXTRAS.get(string));
                }
                if (DEFAULT_ENERGY_MODIFIERS.containsKey(string)) {
                    oreEntry3.setEnergyModifier(DEFAULT_ENERGY_MODIFIERS.get(string));
                }
                allEntries.add(oreEntry3);
                JAOPCAApi.LOGGER.debug("Found gem ore " + string);
            }
        }
        TreeSet<String> treeSet = OreFinder.getMaterialsWithPrefixes("ore", "dust");
        treeSet.removeAll(allOres);
        allOres.addAll(treeSet);
        if (JAOPCAConfig.dust) {
            block4: for (String string : treeSet) {
                for (String string4 : CONTAINING_BLACKLIST) {
                    if (!string.contains(string4)) continue;
                    continue block4;
                }
                OreEntry oreEntry4 = new OreEntry(string);
                if (DEFAULT_ORE_SYNONYMS.containsKey((Object)string)) {
                    oreEntry4.setOreNameSynonyms(DEFAULT_ORE_SYNONYMS.get((Object)string));
                }
                oreEntry4.setOreType(EnumOreType.DUST);
                if (DEFAULT_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_EXTRAS.get(string))) {
                    oreEntry4.setExtra(DEFAULT_EXTRAS.get(string));
                }
                if (DEFAULT_SECOND_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_SECOND_EXTRAS.get(string))) {
                    oreEntry4.setSecondExtra(DEFAULT_SECOND_EXTRAS.get(string));
                }
                if (DEFAULT_THIRD_EXTRAS.containsKey(string) && Utils.doesOreNameExist("ore" + DEFAULT_THIRD_EXTRAS.get(string))) {
                    oreEntry4.setThirdExtra(DEFAULT_THIRD_EXTRAS.get(string));
                }
                if (DEFAULT_ENERGY_MODIFIERS.containsKey(string)) {
                    oreEntry4.setEnergyModifier(DEFAULT_ENERGY_MODIFIERS.get(string));
                }
                if (DEFAULT_RARITIES.containsKey(string)) {
                    oreEntry4.setRarity(DEFAULT_RARITIES.get(string));
                }
                allEntries.add(oreEntry4);
                JAOPCAApi.LOGGER.debug("Found dust ore " + string);
            }
        }
        TreeSet<String> treeSet2 = OreFinder.getMaterialsWithPrefixButNot("ingot", "ore");
        treeSet2.removeAll(SHOULD_BE_GEMS);
        treeSet2.removeAll(allOres);
        allOres.addAll(treeSet2);
        if (JAOPCAConfig.ingot_oreless) {
            block6: for (String string : treeSet2) {
                for (String string5 : CONTAINING_BLACKLIST) {
                    if (!string.contains(string5)) continue;
                    continue block6;
                }
                OreEntry oreEntry5 = new OreEntry(string);
                oreEntry5.setOreType(EnumOreType.INGOT_ORELESS);
                if (DEFAULT_ORE_SYNONYMS.containsKey((Object)string)) {
                    oreEntry5.setOreNameSynonyms(DEFAULT_ORE_SYNONYMS.get((Object)string));
                }
                if (DEFAULT_ENERGY_MODIFIERS.containsKey(string)) {
                    oreEntry5.setEnergyModifier(DEFAULT_ENERGY_MODIFIERS.get(string));
                }
                if (DEFAULT_RARITIES.containsKey(string)) {
                    oreEntry5.setRarity(DEFAULT_RARITIES.get(string));
                }
                allEntries.add(oreEntry5);
                JAOPCAApi.LOGGER.debug("Found ingot " + string);
            }
        }
        TreeSet<String> treeSet3 = OreFinder.getMaterialsWithPrefixButNot("gem", "ore");
        treeSet3.removeAll(allOres);
        allOres.addAll(treeSet3);
        if (JAOPCAConfig.gem_oreless) {
            block8: for (String string : treeSet3) {
                for (String ignored : CONTAINING_BLACKLIST) {
                    if (!string.contains(ignored)) continue;
                    continue block8;
                }
                OreEntry oreEntry6 = new OreEntry(string);
                oreEntry6.setOreType(EnumOreType.GEM_ORELESS);
                if (DEFAULT_ORE_SYNONYMS.containsKey((Object)string)) {
                    oreEntry6.setOreNameSynonyms(DEFAULT_ORE_SYNONYMS.get((Object)string));
                }
                if (DEFAULT_ENERGY_MODIFIERS.containsKey(string)) {
                    oreEntry6.setEnergyModifier(DEFAULT_ENERGY_MODIFIERS.get(string));
                }
                if (DEFAULT_RARITIES.containsKey(string)) {
                    oreEntry6.setRarity(DEFAULT_RARITIES.get(string));
                }
                allEntries.add(oreEntry6);
                JAOPCAApi.LOGGER.debug("Found gem " + string);
            }
        }
        JAOPCAApi.ORE_ENTRY_LIST.addAll(allEntries);
        EnumOreType[] enumOreTypeArray = EnumOreType.values();
        int n = enumOreTypeArray.length;
        boolean bl = false;
        while (var9_46 < n) {
            EnumOreType type = enumOreTypeArray[var9_46];
            LinkedHashSet oreSet = Sets.newLinkedHashSet();
            allEntries.stream().filter(oreEntry -> type == oreEntry.getOreType()).forEach(oreSet::add);
            JAOPCAApi.ORE_TYPE_TO_ORES_MAP.putAll((Object)type, (Iterable)oreSet);
            ++var9_46;
        }
        JAOPCAConfig.initOreConfigs(allEntries);
    }

    public static TreeSet<String> getMaterialsWithPrefixes(String prefix1, String prefix2) {
        TreeSet ores = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix1) || !Utils.doesOreNameExist(name)) continue;
            String oreName = name.substring(prefix1.length());
            if (!Utils.doesOreNameExist(prefix2 + oreName)) continue;
            if (!ores.contains(oreName)) {
                ores.add(oreName);
                continue;
            }
            String oreNameInSet = ores.stream().filter(str -> str.equalsIgnoreCase(oreName)).findAny().orElse(oreName);
            OreFinder.confictingSuffixReplace(oreNameInSet, oreName);
            ores.remove(oreNameInSet);
            ores.add(OreFinder.determinePrecedentSuffix(oreNameInSet, oreName));
        }
        return ores;
    }

    public static TreeSet<String> getMaterialsWithPrefixButNot(String prefix1, String prefix2) {
        TreeSet ores = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        block0: for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix1) || !Utils.doesOreNameExist(name)) continue;
            for (String prefixB : PREFIX_BLACKLIST) {
                String oreName;
                if (!name.startsWith(prefixB) || (oreName = name.substring(prefixB.length())).length() <= 0 || !Character.isUpperCase(oreName.charAt(0))) continue;
                continue block0;
            }
            String oreName = name.substring(prefix1.length());
            if (Utils.doesOreNameExist(prefix2 + oreName)) continue;
            if (!ores.contains(oreName)) {
                ores.add(oreName);
                continue;
            }
            String oreNameInSet = ores.stream().filter(str -> str.equalsIgnoreCase(oreName)).findAny().orElse(oreName);
            OreFinder.confictingSuffixReplace(oreNameInSet, oreName);
            ores.remove(oreNameInSet);
            ores.add(OreFinder.determinePrecedentSuffix(oreNameInSet, oreName));
        }
        return ores;
    }

    public static String determinePrecedentSuffix(String suffix1, String suffix2) {
        long count2;
        int flag = 0;
        if (CONFLICT_PRECEDENCE.contains(suffix1)) {
            ++flag;
        }
        if (CONFLICT_PRECEDENCE.contains(suffix2)) {
            flag += 2;
        }
        if (flag == 1) {
            return suffix1;
        }
        if (flag == 2) {
            return suffix2;
        }
        long count1 = suffix1.chars().filter(Character::isUpperCase).count();
        return count1 > (count2 = suffix2.chars().filter(Character::isUpperCase).count()) ? suffix1 : suffix2;
    }

    public static void confictingSuffixReplace(String suffix1, String suffix2) {
        for (String name : OreDictionary.getOreNames()) {
            String replaced;
            if (name.endsWith(suffix1)) {
                replaced = StringUtils.removeEnd((String)name, (String)suffix1) + suffix2;
                for (ItemStack stack : OreDictionary.getOres((String)name, (boolean)false)) {
                    OreDictionary.registerOre((String)replaced, (ItemStack)stack);
                }
            }
            if (!name.endsWith(suffix2)) continue;
            replaced = StringUtils.removeEnd((String)name, (String)suffix2) + suffix1;
            for (ItemStack stack : OreDictionary.getOres((String)name, (boolean)false)) {
                OreDictionary.registerOre((String)replaced, (ItemStack)stack);
            }
        }
        DEFAULT_ORE_SYNONYMS.put((Object)suffix1, (Object)suffix2);
        DEFAULT_ORE_SYNONYMS.put((Object)suffix2, (Object)suffix1);
    }

    static {
        DEFAULT_ORE_SYNONYMS.put((Object)"Aluminium", (Object)"Aluminum");
        DEFAULT_ORE_SYNONYMS.put((Object)"Sulfur", (Object)"Sulphur");
        DEFAULT_ORE_SYNONYMS.put((Object)"Chromium", (Object)"Chrome");
        DEFAULT_ORE_SYNONYMS.put((Object)"Caesium", (Object)"Cesium");
        DEFAULT_ORE_SYNONYMS.put((Object)"Niter", (Object)"Saltpeter");
        DEFAULT_EXTRAS.put("Cobalt", "Iron");
        DEFAULT_EXTRAS.put("Ardite", "Gold");
        DEFAULT_EXTRAS.put("Aluminium", "Iron");
        DEFAULT_EXTRAS.put("Copper", "Gold");
        DEFAULT_EXTRAS.put("Tin", "Iron");
        DEFAULT_EXTRAS.put("Lead", "Silver");
        DEFAULT_EXTRAS.put("Iron", "Nickel");
        DEFAULT_EXTRAS.put("Silver", "Lead");
        DEFAULT_EXTRAS.put("Nickel", "Platinum");
        DEFAULT_EXTRAS.put("Platinum", "Iridium");
        DEFAULT_EXTRAS.put("Iridium", "Platinum");
        DEFAULT_EXTRAS.put("Mithril", "Gold");
        DEFAULT_EXTRAS.put("FzDarkIron", "Silver");
    }
}

