/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.common.entity.EntityArrow;
import slimeknights.tconstruct.tools.tools.Pickaxe;

public class AchievementEvents {
    private static final String ADVANCEMENT_STORY_ROOT = "minecraft:story/root";
    private static final String ADVANCEMENT_STONE_PICK = "minecraft:story/upgrade_tools";
    private static final String ADVANCEMENT_IRON_PICK = "minecraft:story/iron_tools";
    public static final String ADVANCEMENT_SHOOT_ARROW = "minecraft:adventure/shoot_arrow";

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player instanceof FakePlayer || !(event.player instanceof EntityPlayerMP) || event.crafting.func_190926_b()) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
        Item item = event.crafting.func_77973_b();
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() == Blocks.field_150462_ai) {
            this.grantAdvancement(playerMP, ADVANCEMENT_STORY_ROOT);
        }
        if (item instanceof Pickaxe) {
            int harvestLevel = TagUtil.getToolStats((ItemStack)event.crafting).harvestLevel;
            if (harvestLevel > 0) {
                this.grantAdvancement(playerMP, ADVANCEMENT_STONE_PICK);
            }
            if (harvestLevel > 1) {
                this.grantAdvancement(playerMP, ADVANCEMENT_IRON_PICK);
            }
        }
    }

    @SubscribeEvent
    public void onDamageEntity(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76352_a() && !(source.func_76346_g() instanceof FakePlayer) && source.func_76346_g() instanceof EntityPlayerMP && source.func_76364_f() instanceof EntityArrow) {
            this.grantAdvancement((EntityPlayerMP)source.func_76346_g(), ADVANCEMENT_SHOOT_ARROW);
        }
    }

    private void grantAdvancement(EntityPlayerMP playerMP, String advancementResource) {
        AdvancementProgress advancementProgress;
        Advancement advancement = playerMP.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation(advancementResource));
        if (advancement != null && !(advancementProgress = playerMP.func_192039_O().func_192747_a(advancement)).func_192105_a()) {
            advancementProgress.func_192107_d().forEach(criterion -> playerMP.func_192039_O().func_192750_a(advancement, criterion));
        }
    }
}

