/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMachineUpgrade
extends ItemPneumatic {
    public static final String NBT_DIRECTION = "Facing";
    private final int index;

    public ItemMachineUpgrade(String registryName, int index) {
        super(registryName);
        this.index = index;
    }

    public IItemRegistry.EnumUpgrade getUpgradeType() {
        return IItemRegistry.EnumUpgrade.values()[this.index];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> infoList, ITooltipFlag par4) {
        if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.item.upgrade.usedIn", (Object[])new Object[0]));
            PneumaticRegistry.getInstance().getItemRegistry().addTooltip(this, infoList);
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.item.upgrade.shiftMessage", (Object[])new Object[0]));
        }
        if (this.getUpgradeType() == IItemRegistry.EnumUpgrade.DISPENSER) {
            EnumFacing dir = stack.func_77942_o() ? EnumFacing.func_176739_a((String)NBTUtil.getString(stack, NBT_DIRECTION)) : null;
            infoList.add(I18n.func_135052_a((String)"message.dispenser.direction", (Object[])new Object[]{dir == null ? "*" : dir.func_176610_l()}));
            infoList.add(I18n.func_135052_a((String)"message.dispenser.clickToSet", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, world, infoList, par4);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (this.getUpgradeType() == IItemRegistry.EnumUpgrade.DISPENSER) {
            if (!world.field_72995_K) {
                this.setDirection(player, hand, side);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.getUpgradeType() == IItemRegistry.EnumUpgrade.DISPENSER) {
            if (!worldIn.field_72995_K) {
                this.setDirection(playerIn, handIn, null);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void setDirection(EntityPlayer player, EnumHand hand, EnumFacing facing) {
        ItemStack stack = player.func_184586_b(hand);
        if (facing == null) {
            stack.func_77982_d(null);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.dispenser.direction", new Object[]{"*"}), true);
        } else {
            NBTUtil.setString(stack, NBT_DIRECTION, facing.func_176610_l());
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.dispenser.direction", new Object[]{facing.func_176610_l()}), true);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getUpgradeType() == IItemRegistry.EnumUpgrade.CREATIVE ? EnumRarity.EPIC : EnumRarity.COMMON;
    }
}

