/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.obnoxint.xnbt.BaseTag;
import net.obnoxint.xnbt.types.NBTTag;
import net.obnoxint.xnbt.types.TagHeader;

public abstract class AbstractListTag
extends BaseTag
implements List<NBTTag> {
    private static List<NBTTag> sanitizePayload(List<NBTTag> payload) {
        if (payload == null) {
            return new ArrayList<NBTTag>();
        }
        byte t = -1;
        for (NBTTag e : payload) {
            if (e == null) {
                throw new NullPointerException("payload must not contain null elements");
            }
            if (t == -1) {
                t = e.getHeader().getType();
                if (t != NBTTag.BaseType.END.Id()) continue;
                throw new IllegalArgumentException("ListTag must not contain EndTags");
            }
            if (t == e.getHeader().getType()) continue;
            throw new IllegalArgumentException("NBTTag of type " + e.getHeader().getType() + " can't be added to ListTag because it already contains one or more elements of type " + t);
        }
        return payload;
    }

    protected AbstractListTag(String name, List<NBTTag> payload) {
        super(new TagHeader(NBTTag.BaseType.LIST.Id(), name), AbstractListTag.sanitizePayload(payload));
    }

    @Override
    public final void add(int index, NBTTag element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends NBTTag> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.getPayload().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getPayload().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getPayload().containsAll(c);
    }

    @Override
    public NBTTag get(int index) {
        return (NBTTag)this.getPayload().get(index);
    }

    @Override
    public List<NBTTag> getPayload() {
        return (List)super.getPayload();
    }

    @Override
    public int indexOf(Object o) {
        return this.getPayload().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getPayload().isEmpty();
    }

    @Override
    public Iterator<NBTTag> iterator() {
        return this.getPayload().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getPayload().lastIndexOf(o);
    }

    @Override
    public ListIterator<NBTTag> listIterator() {
        return this.getPayload().listIterator();
    }

    @Override
    public ListIterator<NBTTag> listIterator(int index) {
        return this.getPayload().listIterator(index);
    }

    @Override
    public NBTTag remove(int index) {
        return (NBTTag)this.getPayload().remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.getPayload().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getPayload().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getPayload().retainAll(c);
    }

    @Override
    public final NBTTag set(int index, NBTTag element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPayload(List<NBTTag> payload) {
        super.setPayload(payload == null ? new ArrayList() : AbstractListTag.sanitizePayload(payload));
    }

    @Override
    public int size() {
        return this.getPayload().size();
    }

    @Override
    public List<NBTTag> subList(int fromIndex, int toIndex) {
        return this.getPayload().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getPayload().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getPayload().toArray(a);
    }
}

