/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropCard;
import ic2.api.crops.CropProperties;
import ic2.core.platform.textures.Ic2Icons;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CropCardBase
extends CropCard {
    public CropProperties props;

    public CropCardBase(CropProperties properties) {
        this.props = properties;
    }

    @Override
    public String getDiscoveredBy() {
        return "Alblaka";
    }

    @Override
    public String getOwner() {
        return "ic2";
    }

    @Override
    public String getUnlocalizedName() {
        return "ic2.crop." + this.getId() + ".name";
    }

    @Override
    public CropProperties getProperties() {
        return this.props;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getTexture(int var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTexturesLocation() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (int i = 1; i <= this.getMaxSize(); ++i) {
            TextureAtlasSprite sprite = this.getTexture(i);
            if (sprite == null) {
                FMLLog.getLogger().info("Found NullSprite: " + this.getId() + ": " + i);
                continue;
            }
            textures.add(new ResourceLocation(sprite.func_94215_i()));
        }
        return textures;
    }

    @SideOnly(value=Side.CLIENT)
    protected final TextureAtlasSprite[] getSprite(String id) {
        return Ic2Icons.getTextures(id);
    }
}

