/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.model;

import ic2.api.classic.event.RetextureEventClassic;
import ic2.core.block.base.util.texture.TextureCopyStorage;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ILateModel;
import ic2.core.util.helpers.BlockStateContainerIC2;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelTexturedWall
extends BaseModel
implements ILateModel {
    public static Map<TextureAtlasSprite, BakedQuad[][]> quadCache = new HashMap<TextureAtlasSprite, BakedQuad[][]>();
    public static LinkedList<TextureAtlasSprite> lastUsed = new LinkedList();
    public static Vector3f minVec = new Vector3f(0.0f, 0.0f, 0.0f);
    public static Vector3f maxVec = new Vector3f(16.0f, 16.0f, 16.0f);
    public static float[] texData = new float[]{0.0f, 0.0f, 16.0f, 16.0f};

    public ModelTexturedWall(TextureAtlasSprite par1) {
        super(Ic2Models.getBlockTransforms());
        this.setParticalTexture(par1);
    }

    @Override
    public void init() {
        quadCache.clear();
    }

    @Override
    public void onLaterLoad() {
        LinkedList<TextureAtlasSprite> sprites = new LinkedList<TextureAtlasSprite>(lastUsed);
        lastUsed.clear();
        for (TextureAtlasSprite sprite : sprites) {
            ModelTexturedWall.getCache(sprite);
        }
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null && state instanceof BlockStateContainerIC2.IC2BlockState) {
            TextureCopyStorage.QuadList copy = (TextureCopyStorage.QuadList)((BlockStateContainerIC2.IC2BlockState)state).getData();
            return copy.getQuads();
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static BakedQuad copyWithIndex(BakedQuad quad, int index) {
        return new BakedQuad(quad.func_178209_a(), index, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    @SideOnly(value=Side.CLIENT)
    public static BakedQuad[][] getCache(TextureAtlasSprite sprite) {
        BakedQuad[][] quads = quadCache.get(sprite);
        if (quads == null) {
            quads = new BakedQuad[6][4];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                for (RetextureEventClassic.Rotation rotation : RetextureEventClassic.Rotation.values()) {
                    quads[facing.func_176745_a()][rotation.ordinal()] = Ic2Models.getBakery().func_178414_a(minVec, maxVec, new BlockPartFace(null, -1, "", new BlockFaceUV(texData, rotation.getRotation())), sprite, facing, ModelRotation.X0_Y0, null, true, true);
                }
            }
            quadCache.put(sprite, quads);
        }
        lastUsed.remove(sprite);
        lastUsed.add(sprite);
        if (lastUsed.size() > 1000) {
            quadCache.remove(lastUsed.pollFirst());
        }
        return quads;
    }
}

