/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.item.tool.ItemToolTreetap;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolTreetap
extends ItemElectricTool
implements IStaticTexturedItem {
    public ItemElectricToolTreetap() {
        super(0.0f, 0.0f, Item.ToolMaterial.STONE);
        this.func_77656_e(27);
        this.setUnlocalizedName(Ic2ItemLang.treeTapElectric);
        this.field_77864_a = 0.0f;
        this.operationEnergyCost = 50;
        this.maxCharge = 10000;
        this.tier = 1;
        this.transferLimit = 100;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isImport(stack)) {
            tooltip.add(Ic2InfoLang.treeTapEffect.getLocalized());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (worldIn.func_180495_p(pos).func_177230_c() == Ic2States.rubberWood.func_177230_c()) {
            if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
                return EnumActionResult.PASS;
            }
            boolean server = IC2.platform.isSimulating();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            EnumActionResult didSomething = ItemToolTreetap.attemptExtract(stack, player, worldIn, pos, facing, this.isImport(stack) ? list : null);
            if (didSomething == EnumActionResult.SUCCESS && server) {
                ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
                for (ItemStack item : list) {
                    if (player.field_71071_by.func_70441_a(item)) continue;
                    player.func_71019_a(item, false);
                }
            }
            return didSomething;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[36];
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        if (ench == Enchantments.field_185308_t) {
            return true;
        }
        return super.isSpecialSupported(item, ench);
    }

    public boolean isImport(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Import");
    }
}

