/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.question;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.question.component.Malus;
import fr.nocturne123.questionstime.question.component.Prize;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class Question {
    private String question;
    private String answer;
    private Prize prize;
    private Malus malus;
    private int timer;
    private int timeBetweenAnswer;
    private int weight;

    protected Question(QuestionBuilder builder) {
        this.question = builder.question;
        this.answer = builder.answer;
        this.timer = builder.timer;
        this.prize = builder.prize;
        this.malus = builder.malus;
        this.timeBetweenAnswer = builder.timeBetweenAnswer;
        this.weight = builder.weight;
    }

    public static QuestionBuilder builder() {
        return new QuestionBuilder();
    }

    public Optional<Prize> getPrize() {
        return Optional.ofNullable(this.prize);
    }

    public static Types getType(ConfigurationNode questionnode) {
        if (questionnode.getNode(new Object[]{"question"}).getValue() != null && questionnode.getNode(new Object[]{"answer"}).getValue() != null) {
            if (questionnode.getNode(new Object[]{"proposition"}).getValue() != null) {
                return Types.MULTI;
            }
            return Types.SIMPLE;
        }
        return Types.ERROR;
    }

    public String getAnswer() {
        return this.answer;
    }

    public String getQuestion() {
        return this.question;
    }

    public Types getType() {
        return Types.SIMPLE;
    }

    public Optional<Malus> getMalus() {
        return Optional.ofNullable(this.malus);
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean isTimed() {
        return this.timer > 0;
    }

    public boolean isTimeBetweenAnswer() {
        return this.timeBetweenAnswer > 0;
    }

    public int getTimeBetweenAnswer() {
        return this.timeBetweenAnswer;
    }

    public int getWeight() {
        return this.weight;
    }

    public static class QuestionBuilder<T extends QuestionBuilder<T>> {
        protected String question;
        protected String answer;
        protected Prize prize;
        protected Malus malus;
        protected int timer;
        protected int timeBetweenAnswer;
        protected int weight;

        public T setQuestion(String question) {
            this.question = question;
            return (T)this;
        }

        public T setAnswer(String answer) {
            this.answer = answer;
            return (T)this;
        }

        public T setMalus(Malus malus) {
            this.malus = malus;
            return (T)this;
        }

        public T setMalus(ConfigurationNode malusNode) {
            try {
                this.malus = (Malus)malusNode.getValue(TypeToken.of(Malus.class));
            }
            catch (ObjectMappingException e) {
                QuestionsTime.getInstance().getLogger().error("Error when reading the malus node");
                e.printStackTrace();
            }
            return (T)this;
        }

        public T setPrize(Prize prize) {
            this.prize = prize;
            return (T)this;
        }

        public T setPrize(ConfigurationNode prizeNode) {
            try {
                this.prize = (Prize)prizeNode.getValue(TypeToken.of(Prize.class));
            }
            catch (ObjectMappingException e) {
                QuestionsTime.getInstance().getLogger().error("Error when reading the prize node");
                e.printStackTrace();
            }
            return (T)this;
        }

        public T setTimeBetweenAnswer(int timeBetweenAnswer) {
            this.timeBetweenAnswer = timeBetweenAnswer;
            return (T)this;
        }

        public T setTimer(int timer) {
            this.timer = timer;
            return (T)this;
        }

        public T setWeight(int weight) {
            this.weight = weight;
            return (T)this;
        }

        public Question build() {
            if (Strings.isNullOrEmpty((String)this.question)) {
                throw new NullPointerException("The question is null or empty");
            }
            if (Strings.isNullOrEmpty((String)this.answer)) {
                throw new NullPointerException("The answer is null");
            }
            return new Question(this);
        }
    }

    public static enum Types {
        SIMPLE,
        MULTI,
        ERROR;

    }
}

