/*
 * Decompiled with CFR 0.152.
 */
package fr.nocturne123.questionstime.question;

import com.google.common.reflect.TypeToken;
import fr.nocturne123.questionstime.QuestionsTime;
import fr.nocturne123.questionstime.question.Question;
import fr.nocturne123.questionstime.question.QuestionMulti;
import fr.nocturne123.questionstime.question.component.Malus;
import fr.nocturne123.questionstime.question.component.Prize;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class QuestionSerializer
implements TypeSerializer<Question> {
    private Logger logger = QuestionsTime.getInstance().getLogger();

    public Question deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        Question.Types questioneType = Question.getType(node);
        if (questioneType == Question.Types.ERROR) {
            throw new ObjectMappingException("The question " + node.getKey() + " contain one or many errors. Check if he contain the sections \"question\" and \"answer\" at least. ");
        }
        String question = node.getNode(new Object[]{"question"}).getString();
        String answer = node.getNode(new Object[]{"answer"}).getString();
        int timer = node.getNode(new Object[]{"timer"}).getInt();
        int timeBetweenAnswer = node.getNode(new Object[]{"time-between-answer"}).getInt();
        int weight = node.getNode(new Object[]{"weight"}).getInt(10);
        ConfigurationNode prize = node.getNode(new Object[]{"prize"});
        ConfigurationNode malus = node.getNode(new Object[]{"malus"});
        if (questioneType == Question.Types.SIMPLE) {
            return ((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)((Question.QuestionBuilder)Question.builder().setQuestion(question)).setPrize(prize)).setAnswer(answer)).setMalus(malus)).setTimer(timer)).setTimeBetweenAnswer(timeBetweenAnswer)).setWeight(weight)).build();
        }
        if (questioneType == Question.Types.MULTI) {
            if (!StringUtils.isNumeric((CharSequence)answer) || Integer.valueOf(answer) > 127 || Integer.valueOf(answer) < 0) {
                this.logger.error("The question \"" + node.getKey() + "\" answer need to be a number between 0 and 127");
                return null;
            }
            ConfigurationNode propositions = node.getNode(new Object[]{"proposition"});
            if (!(propositions.getValue() instanceof List) || propositions.getChildrenList().size() <= 1) {
                this.logger.error("The question \"" + node.getKey() + "\" answer need to have at least 2 propositions");
                return null;
            }
            byte answerNumber = Byte.parseByte(answer);
            QuestionMulti.QuestionMultiBuilder questionMultiBuilder = (QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)((QuestionMulti.QuestionMultiBuilder)QuestionMulti.builder().setQuestion(question)).setPrize(prize)).setMalus(malus)).setAnswer(answerNumber).setTimer(timer)).setTimeBetweenAnswer(timeBetweenAnswer)).setWeight(weight);
            propositions.getChildrenList().forEach(proposition -> questionMultiBuilder.addProposition(proposition.getString()));
            return questionMultiBuilder.build();
        }
        this.logger.error("This never should happen, but she happened, so... just report the error with the more information you have");
        return null;
    }

    public void serialize(TypeToken<?> type, Question question, ConfigurationNode node) {
        node.getNode(new Object[]{"question"}).setValue((Object)question.getQuestion());
        node.getNode(new Object[]{"answer"}).setValue((Object)question.getAnswer());
        node.getNode(new Object[]{"timer"}).setValue((Object)question.getTimer());
        node.getNode(new Object[]{"time-between-answer"}).setValue((Object)question.getTimeBetweenAnswer());
        node.getNode(new Object[]{"weight"}).setValue((Object)question.getWeight());
        if (question instanceof QuestionMulti) {
            node.getNode(new Object[]{"proposition"}).setValue(((QuestionMulti)question).getPropositions());
        }
        ConfigurationNode prizeNode = node.getNode(new Object[]{"prize"});
        Optional<Prize> prizeOptional = question.getPrize();
        prizeOptional.ifPresent(prize -> {
            try {
                prizeNode.setValue(TypeToken.of(Prize.class), prize);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        });
        ConfigurationNode malusNode = node.getNode(new Object[]{"malus"});
        Optional<Malus> malusOptional = question.getMalus();
        malusOptional.ifPresent(malus -> {
            try {
                malusNode.setValue(TypeToken.of(Malus.class), malus);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        });
    }
}

