/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionVehicle;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagVehiclePlaceListener {
    @Listener
    public void onInteract(SpawnEntityEvent event, @First Player player) {
        EntityType type;
        if (event.getContext().containsKey(EventContextKeys.SPAWN_TYPE) && ((SpawnType)event.getContext().get(EventContextKeys.SPAWN_TYPE).get()).equals(SpawnTypes.PLACEMENT) && !event.getEntities().isEmpty() && FlagUtils.isVehicle(type = ((Entity)event.getEntities().get(0)).getType())) {
            EnumRegionVehicle vehicle = FlagUtils.getVehicle(type);
            this.handleEvent(event, vehicle, player);
        }
    }

    private void handleEvent(SpawnEntityEvent event, EnumRegionVehicle vehicle, Player player) {
        Region region = RegionUtils.getRegion((Location<World>)player.getLocation());
        if (region != null && vehicle != null) {
            boolean cancel;
            boolean bl = cancel = !region.getVehiclePlace(vehicle) && !RegionUtils.hasPermission(player, region);
            if (cancel) {
                event.setCancelled(true);
                if (player != null) {
                    MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                }
            }
        }
    }
}

