/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import com.universeguard.UniverseGuard;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.components.RegionLocation;
import com.universeguard.region.enums.EnumDirection;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RegionLocationUtils {
    public static String getDimension(Player player) {
        return player.getWorld().getDimension().getType().getId();
    }

    public static String getWorld(Player player) {
        return player.getWorld().getName();
    }

    public static RegionLocation fromLocation(Player player, Location<World> location) {
        return RegionLocationUtils.create(location.getBlockX(), location.getBlockY(), location.getBlockZ(), RegionLocationUtils.getDimension(player), RegionLocationUtils.getWorld(player));
    }

    public static RegionLocation fromCoordinates(Player player, int x, int y, int z) {
        return RegionLocationUtils.create(x, y, z, RegionLocationUtils.getDimension(player), RegionLocationUtils.getWorld(player));
    }

    public static RegionLocation create(int x, int y, int z, String dimension, String world) {
        return new RegionLocation(x, y, z, dimension, world);
    }

    public static boolean isMaxSize(LocalRegion region) {
        if (UniverseGuard.LIMIT_REGIONS_SIZE) {
            int distanceX = Math.abs(region.getFirstPoint().getX() - region.getSecondPoint().getX());
            int distanceY = Math.abs(region.getFirstPoint().getY() - region.getSecondPoint().getY());
            int distanceZ = Math.abs(region.getFirstPoint().getZ() - region.getSecondPoint().getZ());
            int maxsize = UniverseGuard.MAX_REGION_SIZE;
            return distanceX > maxsize || distanceY > maxsize || distanceZ > maxsize;
        }
        return false;
    }

    public static void expandPoint(LocalRegion region, EnumDirection direction, boolean hasBlocks, int blocks) {
        RegionLocation firstPoint = region.getFirstPoint();
        RegionLocation secondPoint = region.getSecondPoint();
        switch (direction) {
            default: {
                if (firstPoint.getY() >= secondPoint.getY()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX(), hasBlocks ? firstPoint.getY() + blocks : 256, firstPoint.getZ(), firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX(), hasBlocks ? secondPoint.getY() + blocks : 256, secondPoint.getZ(), secondPoint.getDimension(), secondPoint.getWorld()));
                break;
            }
            case DOWN: {
                if (firstPoint.getY() <= secondPoint.getY()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX(), hasBlocks ? firstPoint.getY() - blocks : 0, firstPoint.getZ(), firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX(), hasBlocks ? secondPoint.getY() - blocks : 0, secondPoint.getZ(), secondPoint.getDimension(), secondPoint.getWorld()));
                break;
            }
            case LEFT: 
            case WEST: {
                if (firstPoint.getX() <= secondPoint.getX()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX() - blocks, firstPoint.getY(), firstPoint.getZ(), firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX() - blocks, secondPoint.getY(), secondPoint.getZ(), secondPoint.getDimension(), secondPoint.getWorld()));
                break;
            }
            case RIGHT: 
            case EAST: {
                if (firstPoint.getX() >= secondPoint.getX()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX() + blocks, firstPoint.getY(), firstPoint.getZ(), firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX() + blocks, secondPoint.getY(), secondPoint.getZ(), secondPoint.getDimension(), secondPoint.getWorld()));
                break;
            }
            case FRONT: 
            case SOUTH: {
                if (firstPoint.getZ() >= secondPoint.getZ()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX(), firstPoint.getY(), firstPoint.getZ() + blocks, firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX(), secondPoint.getY(), secondPoint.getZ() + blocks, secondPoint.getDimension(), secondPoint.getWorld()));
                break;
            }
            case BACK: 
            case NORTH: {
                if (firstPoint.getZ() <= secondPoint.getZ()) {
                    region.setFirstPoint(new RegionLocation(firstPoint.getX(), firstPoint.getY(), firstPoint.getZ() - blocks, firstPoint.getDimension(), firstPoint.getWorld()));
                    break;
                }
                region.setSecondPoint(new RegionLocation(secondPoint.getX(), secondPoint.getY(), secondPoint.getZ() - blocks, secondPoint.getDimension(), secondPoint.getWorld()));
            }
        }
    }
}

