/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.config;

import com.google.common.reflect.TypeToken;
import java.io.File;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.config.CCLConfig;
import me.time6628.clag.sponge.config.MessagesConfig;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;

public class ConfigLoader {
    private final CatClearLag plugin;
    private CCLConfig cclConfig;
    private ConfigurationLoader<CommentedConfigurationNode> cclLoader;
    private MessagesConfig messagesConfig;

    public ConfigLoader(CatClearLag pl) {
        this.plugin = pl;
        if (!this.plugin.getConfigDir().exists()) {
            this.plugin.getConfigDir().mkdirs();
        }
    }

    public boolean loadConfig() {
        try {
            File file = new File(this.plugin.getConfigDir(), "catclearlag.conf");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.cclLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(file)).build();
            CommentedConfigurationNode config = (CommentedConfigurationNode)this.cclLoader.load(ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)this.plugin.getFactory()).setShouldCopyDefaults(true));
            this.cclConfig = (CCLConfig)config.getValue(TypeToken.of(CCLConfig.class), (Object)new CCLConfig());
            this.cclLoader.save((ConfigurationNode)config);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not load config.", (Throwable)e);
            return false;
        }
    }

    public boolean loadMessages() {
        try {
            File file = new File(this.plugin.getConfigDir(), "messages.conf");
            if (!file.exists()) {
                file.createNewFile();
            }
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(file)).build();
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)this.plugin.getFactory()).setShouldCopyDefaults(true));
            this.messagesConfig = (MessagesConfig)config.getValue(TypeToken.of(MessagesConfig.class), (Object)new MessagesConfig());
            loader.save((ConfigurationNode)config);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not load config.", (Throwable)e);
            return false;
        }
    }

    public void saveConfig(CCLConfig newConfig) {
        try {
            File file = new File(this.plugin.getConfigDir(), "catclearlag.conf");
            if (!file.exists()) {
                file.createNewFile();
            }
            CommentedConfigurationNode config = (CommentedConfigurationNode)this.cclLoader.load(ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)this.plugin.getFactory()).setShouldCopyDefaults(true));
            config.setValue(TypeToken.of(CCLConfig.class), (Object)newConfig);
            this.cclLoader.save((ConfigurationNode)config);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not load config.", (Throwable)e);
        }
    }

    public CCLConfig getCclConfig() {
        return this.cclConfig;
    }

    public MessagesConfig getMessagesConfig() {
        return this.messagesConfig;
    }
}

