/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.commands;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.PluginInfo;
import io.github.aquerr.chestrefill.commands.AbstractCommand;
import io.github.aquerr.chestrefill.entities.RefillableContainer;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

public class ListCommand
extends AbstractCommand
implements CommandExecutor {
    public ListCommand(ChestRefill plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        ArrayList helpList = Lists.newArrayList();
        for (RefillableContainer refillableContainer : super.getPlugin().getContainerManager().getRefillableContainers()) {
            Text.Builder itemsToShow = Text.builder();
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Container's name: ", TextColors.YELLOW, refillableContainer.getName() + "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Items in inventory: \n"})});
            refillableContainer.getItems().forEach(x -> itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, x.getItem().getTranslation().get(), TextColors.RESET, " x" + x.getItem().getQuantity() + "\n"})}));
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{"\n", TextColors.GREEN, "Kit: ", TextColors.WHITE, refillableContainer.getKitName(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "One item at time: ", TextColors.WHITE, refillableContainer.isOneItemAtTime(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Replace existing items: ", TextColors.WHITE, refillableContainer.shouldReplaceExistingItems(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Hidden if no items: ", TextColors.WHITE, refillableContainer.shouldBeHiddenIfNoItems(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Hiding block: ", TextColors.WHITE, refillableContainer.getHidingBlock(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Permission: ", TextColors.WHITE, refillableContainer.getRequiredPermission(), "\n"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{"\n", TextColors.BLUE, TextStyles.BOLD, "Container cooldown: ", refillableContainer.getRestoreTime(), "s"})});
            itemsToShow.append(new Text[]{Text.of((Object[])new Object[]{"\n", TextColors.RED, TextStyles.ITALIC, "Click to teleport..."})});
            Text.Builder chestName = Text.builder();
            if (refillableContainer.getName().equals("")) {
                chestName.append(new Text[]{Text.of((String)"Not named container")});
            } else {
                chestName.append(new Text[]{Text.of((Object[])new Object[]{"Container ", TextColors.YELLOW, refillableContainer.getName()})});
            }
            Text chestText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - ", TextColors.DARK_GREEN, chestName.build(), " at location ", TextColors.YELLOW, refillableContainer.getContainerLocation().getBlockPosition().toString()})}).onHover((HoverAction)TextActions.showText((Text)itemsToShow.build())).onClick((ClickAction)TextActions.executeCallback((Consumer)new ChestTeleport(refillableContainer.getContainerLocation().getBlockPosition()))).build();
            helpList.add(chestText);
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GOLD, "List of Refilling Containers"})).padding(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "-"})).contents((Iterable)helpList).linesPerPage(10);
        paginationBuilder.sendTo((MessageReceiver)source);
        return CommandResult.success();
    }

    private static class ChestTeleport
    implements Consumer<CommandSource> {
        private final Vector3i chestPosition;

        ChestTeleport(Vector3i chestPosition) {
            this.chestPosition = chestPosition;
        }

        @Override
        public void accept(CommandSource source) {
            if (source instanceof Player) {
                Player player = (Player)source;
                player.setLocation(new Location((Extent)player.getWorld(), this.chestPosition));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PluginPrefix, TextColors.GREEN, "You were teleported to the selected container!"}));
            }
        }
    }
}

