/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.chestrefill.entities;

import io.github.aquerr.chestrefill.ChestRefill;
import io.github.aquerr.chestrefill.entities.ContainerLocation;
import io.github.aquerr.chestrefill.entities.RefillableItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;

public class RefillableContainer {
    private String name;
    private ContainerLocation containerLocation;
    private List<RefillableItem> items;
    private BlockType containerBlockType;
    private int restoreTimeInSeconds;
    private boolean oneItemAtTime;
    private boolean replaceExistingItems;
    private boolean hiddenIfNoItems;
    private BlockType hidingBlock;
    private String kitName;
    private String requiredPermission;

    private RefillableContainer(ContainerLocation containerLocation, BlockType containerBlockType, List<RefillableItem> refillableItemList) {
        this("", containerLocation, containerBlockType, refillableItemList, 120, false, true, false, BlockTypes.DIRT, "", "");
    }

    public RefillableContainer(String name, ContainerLocation containerLocation, BlockType containerBlockType, List<RefillableItem> refillableItemList, int time, boolean oneItemAtTime, boolean replaceExistingItems, boolean hiddenIfNoItems, BlockType hidingBlock, String kitName, String requiredPermission) {
        this.name = name;
        this.containerLocation = containerLocation;
        this.restoreTimeInSeconds = time;
        this.items = refillableItemList;
        this.oneItemAtTime = oneItemAtTime;
        this.replaceExistingItems = replaceExistingItems;
        this.hiddenIfNoItems = hiddenIfNoItems;
        this.hidingBlock = hidingBlock;
        this.containerBlockType = containerBlockType;
        this.kitName = kitName;
        this.requiredPermission = requiredPermission;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRestoreTime(int seconds) {
        this.restoreTimeInSeconds = seconds;
    }

    public void setContainerLocation(ContainerLocation containerLocation) {
        this.containerLocation = containerLocation;
    }

    public void setItems(List<RefillableItem> items) {
        this.items = items;
    }

    public void setKit(String kitName) {
        this.kitName = kitName;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    public void setHidingBlock(BlockType hidingBlock) {
        this.hidingBlock = hidingBlock;
    }

    public String getName() {
        return this.name;
    }

    public ContainerLocation getContainerLocation() {
        return this.containerLocation;
    }

    public List<RefillableItem> getItems() {
        return this.items;
    }

    public BlockType getContainerBlockType() {
        return this.containerBlockType;
    }

    public int getRestoreTime() {
        return this.restoreTimeInSeconds;
    }

    public boolean isOneItemAtTime() {
        return this.oneItemAtTime;
    }

    public boolean shouldReplaceExistingItems() {
        return this.replaceExistingItems;
    }

    public boolean shouldBeHiddenIfNoItems() {
        return this.hiddenIfNoItems;
    }

    public BlockType getHidingBlock() {
        return this.hidingBlock;
    }

    public String getKitName() {
        return this.kitName;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public static RefillableContainer fromTileEntity(TileEntity tileEntity, UUID worldUUID) {
        TileEntityCarrier carrier = (TileEntityCarrier)tileEntity;
        ArrayList<RefillableItem> items = new ArrayList<RefillableItem>();
        int slot = 0;
        for (Inventory slotInventory : carrier.getInventory().slots()) {
            if (slotInventory.peek().isPresent()) {
                DataContainer container = ((ItemStack)slotInventory.peek().get()).toContainer();
                items.add(new RefillableItem(ItemStack.builder().fromContainer((DataView)container).build(), slot, 1.0f));
            }
            ++slot;
        }
        return new RefillableContainer(new ContainerLocation(tileEntity.getLocation().getBlockPosition(), worldUUID), tileEntity.getBlock().getType(), items);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RefillableContainer)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.containerLocation.equals(((RefillableContainer)obj).containerLocation)) {
            return false;
        }
        Inventory tempInventory = Inventory.builder().build((Object)ChestRefill.getInstance());
        this.items.forEach(x -> {
            ItemStack tempItemStack = ItemStack.builder().fromItemStack(x.getItem()).build();
            tempInventory.offer(tempItemStack);
        });
        for (RefillableItem comparedItem : ((RefillableContainer)obj).getItems()) {
            if (tempInventory.contains(comparedItem.getItem())) continue;
            return false;
        }
        if (this.restoreTimeInSeconds != ((RefillableContainer)obj).getRestoreTime()) {
            return false;
        }
        if (this.oneItemAtTime != ((RefillableContainer)obj).oneItemAtTime) {
            return false;
        }
        if (this.replaceExistingItems != ((RefillableContainer)obj).replaceExistingItems) {
            return false;
        }
        if (!this.kitName.equals(((RefillableContainer)obj).kitName)) {
            return false;
        }
        if (!this.requiredPermission.equals(((RefillableContainer)obj).requiredPermission)) {
            return false;
        }
        return this.name.equals(((RefillableContainer)obj).name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.oneItemAtTime ? 0 : 1);
        result = 31 * result + (this.hiddenIfNoItems ? 0 : 1);
        result = 31 * result + this.restoreTimeInSeconds;
        result = 31 * result + (this.containerLocation != null ? this.containerLocation.hashCode() : 0);
        result = 31 * result + (this.containerBlockType != null ? this.containerBlockType.hashCode() : 0);
        result = 31 * result + (this.hidingBlock != null ? this.hidingBlock.hashCode() : 0);
        result = 31 * result + (this.kitName != null ? this.kitName.hashCode() : 0);
        result = 31 * result + (this.requiredPermission != null ? this.requiredPermission.hashCode() : 0);
        return result;
    }
}

