/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public final class CommandContext {
    public static final String TARGET_BLOCK_ARG = "targetblock-pos048658";
    public static final String TAB_COMPLETION = "tab-complete-50456";
    private final Multimap<String, Object> parsedArgs = ArrayListMultimap.create();

    public <T> Collection<T> getAll(String key) {
        return Collections.unmodifiableCollection(this.parsedArgs.get((Object)key));
    }

    public <T> Collection<T> getAll(Text key) {
        return this.getAll(ArgUtils.textToArgKey(key));
    }

    public <T> Optional<T> getOne(String key) {
        Collection values = this.parsedArgs.get((Object)key);
        if (values.size() != 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(values.iterator().next());
    }

    public <T> Optional<T> getOne(Text key) {
        return this.getOne(ArgUtils.textToArgKey(key));
    }

    public <T> T requireOne(String key) throws NoSuchElementException, IllegalArgumentException, ClassCastException {
        Collection values = this.parsedArgs.get((Object)key);
        if (values.size() == 1) {
            return (T)values.iterator().next();
        }
        if (values.isEmpty()) {
            throw new NoSuchElementException();
        }
        throw new IllegalArgumentException();
    }

    public <T> T requireOne(Text key) throws NoSuchElementException, IllegalArgumentException, ClassCastException {
        return this.requireOne(ArgUtils.textToArgKey(key));
    }

    public void putArg(String key, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.parsedArgs.put((Object)key, value);
    }

    public void putArg(Text key, Object value) {
        this.putArg(ArgUtils.textToArgKey(key), value);
    }

    public void checkPermission(CommandSource commander, String permission) throws CommandException {
        if (!commander.hasPermission(permission)) {
            throw new CommandException(SpongeApiTranslationHelper.t("You do not have permission to use this command!", new Object[0]));
        }
    }

    public boolean hasAny(String key) {
        return this.parsedArgs.containsKey((Object)key);
    }

    public boolean hasAny(Text key) {
        return this.hasAny(ArgUtils.textToArgKey(key));
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.parsedArgs);
    }

    public void applySnapshot(Snapshot snapshot) {
        this.parsedArgs.clear();
        this.parsedArgs.putAll(snapshot.args);
    }

    public final class Snapshot {
        final Multimap<String, Object> args;

        Snapshot(Multimap<String, Object> args) {
            this.args = ArrayListMultimap.create(args);
        }
    }
}

