/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseAccessor;

public final class InteractionPacketState
extends PacketState<InteractionPacketContext> {
    @Override
    public InteractionPacketContext createNewContext() {
        return new InteractionPacketContext(this);
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InteractionPacketContext context) {
        BlockPos target;
        ItemStack itemInUse;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184614_ca());
        if (stack != null) {
            context.itemUsed(stack);
        }
        if ((itemInUse = ItemStackUtil.cloneDefensive(playerMP.func_184607_cu())) != null) {
            context.activeItem(itemInUse);
        }
        if (!playerMP.field_70170_p.func_175667_e(target = ((CPacketPlayerDigging)packet).func_179715_a())) {
            context.targetBlock(BlockSnapshot.NONE);
        } else {
            context.targetBlock(((WorldServerBridge)playerMP.field_70170_p).bridge$createSnapshot(target, BlockChangeFlags.NONE));
        }
        context.handUsed(HandTypes.MAIN_HAND);
    }

    @Override
    public boolean spawnEntityOrCapture(InteractionPacketContext context, Entity entity, int chunkX, int chunkZ) {
        return context.captureEntity(entity);
    }

    @Override
    public boolean shouldCaptureEntity() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops(InteractionPacketContext context) {
        return true;
    }

    @Override
    public boolean tracksTileEntityChanges(InteractionPacketContext currentContext) {
        return true;
    }

    @Override
    public boolean hasSpecificBlockProcess(InteractionPacketContext context) {
        return true;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(InteractionPacketContext context) {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops(InteractionPacketContext context) {
        return true;
    }

    @Override
    public boolean alreadyProcessingBlockItemDrops() {
        return true;
    }

    @Override
    public void unwind(InteractionPacketContext phaseContext) {
        EntityPlayerMP player = phaseContext.getPacketPlayer();
        ItemStack usedStack = phaseContext.getItemUsed();
        HandType usedHand = phaseContext.getHandUsed();
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        Entity spongePlayer = (Entity)player;
        BlockSnapshot targetBlock = phaseContext.getTargetBlock();
        net.minecraft.item.ItemStack endActiveItem = player.func_184607_cu();
        ((EntityLivingBaseAccessor)player).accessor$setActiveItemStack((net.minecraft.item.ItemStack)phaseContext.getActiveItem());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            BlockSnapshot firstBlockChange;
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            frame.addContext(EventContextKeys.USED_ITEM, usedSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, usedHand);
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
            boolean hasBlocks = !phaseContext.getCapturedBlockSupplier().isEmpty();
            List<SpongeBlockSnapshot> capturedBlcoks = phaseContext.getCapturedOriginalBlocksChanged();
            BlockSnapshot blockSnapshot = hasBlocks ? (capturedBlcoks.isEmpty() ? null : (BlockSnapshot)capturedBlcoks.get(0)) : (firstBlockChange = null);
            if (hasBlocks && !TrackingUtil.processBlockCaptures(phaseContext)) {
                phaseContext.getBlockItemDropSupplier().get().clear();
                phaseContext.getCapturedItems().clear();
                phaseContext.getPerEntityItemDropSupplier().get().clear();
                phaseContext.getCapturedEntities().clear();
                return;
            }
            phaseContext.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
                if (ShouldFire.DROP_ITEM_EVENT_DESTRUCT) {
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        if (((Collection)entry.getValue()).isEmpty()) continue;
                        List items = ((Collection)entry.getValue()).stream().map(entity -> (Entity)entity).collect(Collectors.toList());
                        DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                        SpongeImpl.postEvent(event);
                        if (event.isCancelled()) continue;
                        InteractionPacketState.processSpawnedEntities(player, event);
                    }
                } else {
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        if (((Collection)entry.getValue()).isEmpty()) continue;
                        InteractionPacketState.processEntities(player, (Collection)entry.getValue());
                    }
                }
            });
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<Entity> entities = new ArrayList<Entity>();
                for (EntityItem item : items) {
                    entities.add((Entity)item);
                }
                DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dispense);
                if (!dispense.isCancelled()) {
                    InteractionPacketState.processSpawnedEntities(player, dispense);
                }
            });
            phaseContext.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
                if (map.isEmpty()) {
                    return;
                }
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interaction").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : (Collection)entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> this.throwEntitySpawnEvents(phaseContext, player, usedSnapshot, firstBlockChange, (Collection<Entity>)entities));
            phaseContext.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty(multimap -> {
                for (Map.Entry entry : multimap.asMap().entrySet()) {
                    if (((UUID)entry.getKey()).equals(player.func_110124_au())) {
                        this.throwEntitySpawnEvents(phaseContext, player, usedSnapshot, firstBlockChange, (Collection)entry.getValue());
                        continue;
                    }
                    net.minecraft.entity.Entity spawnedEntity = ((WorldServer)player.field_70170_p).func_175733_a((UUID)entry.getKey());
                    if (spawnedEntity == null) continue;
                    CauseStackManager.StackFrame entityFrame = Sponge.getCauseStackManager().pushCauseFrame();
                    Throwable throwable = null;
                    try {
                        entityFrame.pushCause(spawnedEntity);
                        this.throwEntitySpawnEvents(phaseContext, player, usedSnapshot, firstBlockChange, (Collection)entry.getValue());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (entityFrame == null) continue;
                        if (throwable != null) {
                            try {
                                entityFrame.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        entityFrame.close();
                    }
                }
            });
            TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.field_71070_bA;
            trackedInventory.bridge$setCaptureInventory(false);
            trackedInventory.bridge$getCapturedSlotTransactions().clear();
        }
        ((EntityLivingBaseAccessor)player).accessor$setActiveItemStack(endActiveItem);
    }

    private void throwEntitySpawnEvents(InteractionPacketContext phaseContext, EntityPlayerMP player, ItemStackSnapshot usedSnapshot, BlockSnapshot firstBlockChange, Collection<Entity> entities) {
        CauseStackManager.StackFrame stackFrame;
        Throwable throwable;
        CauseStackManager.StackFrame frame2;
        ArrayList<Entity> projectiles = new ArrayList<Entity>(entities.size());
        ArrayList<Entity> spawnEggs = new ArrayList<Entity>(entities.size());
        ArrayList<Entity> xpOrbs = new ArrayList<Entity>(entities.size());
        ArrayList<Entity> normalPlacement = new ArrayList<Entity>(entities.size());
        ArrayList<Entity> items = new ArrayList<Entity>(entities.size());
        for (Entity entity : entities) {
            if (entity instanceof Projectile || entity instanceof EntityThrowable) {
                projectiles.add(entity);
                continue;
            }
            if (usedSnapshot.getType() == ItemTypes.SPAWN_EGG) {
                spawnEggs.add(entity);
                continue;
            }
            if (entity instanceof EntityItem) {
                items.add(entity);
                continue;
            }
            if (entity instanceof EntityXPOrb) {
                xpOrbs.add(entity);
                continue;
            }
            normalPlacement.add(entity);
        }
        if (!projectiles.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                throwable = null;
                try {
                    frame2.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PROJECTILE);
                    frame2.pushCause(usedSnapshot);
                    SpongeCommonEventFactory.callSpawnEntity(projectiles, phaseContext);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (frame2 != null) {
                        if (throwable != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, projectiles);
            }
        }
        if (!spawnEggs.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                throwable = null;
                try {
                    frame2.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                    frame2.pushCause(usedSnapshot);
                    SpongeCommonEventFactory.callSpawnEntity(spawnEggs, phaseContext);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (frame2 != null) {
                        if (throwable != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, spawnEggs);
            }
        }
        if (!items.isEmpty()) {
            if (ShouldFire.DROP_ITEM_EVENT_DISPENSE) {
                DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), items);
                if (!SpongeImpl.postEvent(dispense)) {
                    InteractionPacketState.processSpawnedEntities(player, dispense);
                }
            } else {
                InteractionPacketState.processEntities(player, items);
            }
        }
        if (!xpOrbs.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                stackFrame = Sponge.getCauseStackManager().pushCauseFrame();
                throwable = null;
                try {
                    if (firstBlockChange != null) {
                        stackFrame.pushCause(firstBlockChange);
                    }
                    stackFrame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                    SpongeCommonEventFactory.callSpawnEntity(xpOrbs, phaseContext);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stackFrame != null) {
                        if (throwable != null) {
                            try {
                                stackFrame.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            stackFrame.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, xpOrbs);
            }
        }
        if (!normalPlacement.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                stackFrame = Sponge.getCauseStackManager().pushCauseFrame();
                throwable = null;
                try {
                    if (firstBlockChange != null) {
                        stackFrame.pushCause(firstBlockChange);
                    }
                    SpongeCommonEventFactory.callSpawnEntity(normalPlacement, phaseContext);
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (stackFrame != null) {
                        if (throwable != null) {
                            try {
                                stackFrame.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            stackFrame.close();
                        }
                    }
                }
            } else {
                InteractionPacketState.processEntities(player, normalPlacement);
            }
        }
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }
}

