/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.bridge.item.inventory.InventoryAdapterBridge;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.InventoryIterator;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.adapter.impl.SlotCollectionIterator;
import org.spongepowered.common.item.inventory.lens.CompoundSlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.item.inventory.lens.impl.fabric.CompoundFabric;
import org.spongepowered.common.item.inventory.query.Query;
import org.spongepowered.common.item.inventory.query.operation.LensQueryOperation;
import org.spongepowered.common.item.inventory.query.operation.SlotLensQueryOperation;

public interface DefaultImplementedAdapterInventory
extends Inventory {
    @Override
    default public PluginContainer getPlugin() {
        return ((InventoryAdapterBridge)((Object)this)).bridge$getPlugin();
    }

    @Override
    default public Translation getName() {
        if (((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens() == null) {
            return ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric().fabric$getDisplayName();
        }
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens().getName(((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric());
    }

    @Override
    default public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    @Override
    default public Inventory parent() {
        return this;
    }

    @Override
    default public Optional<ItemStack> poll() {
        return AdapterLogic.pollSequential(((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    @Override
    default public Optional<ItemStack> poll(int limit) {
        return AdapterLogic.pollSequential(((InventoryBridge)((Object)this)).bridge$getAdapter(), limit);
    }

    @Override
    default public Optional<ItemStack> peek() {
        return AdapterLogic.peekSequential(((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    @Override
    default public Optional<ItemStack> peek(int limit) {
        return AdapterLogic.peekSequential(((InventoryBridge)((Object)this)).bridge$getAdapter(), limit);
    }

    @Override
    default public InventoryTransactionResult offer(ItemStack stack) {
        return AdapterLogic.appendSequential(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack);
    }

    @Override
    default public boolean canFit(ItemStack stack) {
        return AdapterLogic.canFit(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack);
    }

    @Override
    default public InventoryTransactionResult set(ItemStack stack) {
        return AdapterLogic.insertSequential(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack);
    }

    @Override
    default public int size() {
        return AdapterLogic.countStacks(((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    @Override
    default public int totalItems() {
        return AdapterLogic.countItems(((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    @Override
    default public int capacity() {
        return AdapterLogic.getCapacity(((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    @Override
    default public boolean hasChildren() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens().getChildren().size() != 0;
    }

    @Override
    default public boolean contains(ItemStack stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack);
    }

    @Override
    default public boolean containsAny(ItemStack stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack, 1);
    }

    @Override
    default public boolean contains(ItemType type) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), type);
    }

    @Override
    default public int getMaxStackSize() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens().getMaxStackSize(((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric());
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory child, Class<T> property) {
        return AdapterLogic.getProperties(((InventoryBridge)((Object)this)).bridge$getAdapter(), child, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> property) {
        if (this.parent() == this) {
            return AdapterLogic.getRootProperties(((InventoryBridge)((Object)this)).bridge$getAdapter(), property);
        }
        return this.parent().getProperties(this, property);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory child, Class<T> property, Object key) {
        for (InventoryProperty<?, ?> prop : AdapterLogic.getProperties(((InventoryBridge)((Object)this)).bridge$getAdapter(), child, property)) {
            if (!key.equals(prop.getKey())) continue;
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> property, Object key) {
        if (this.parent() == this) {
            return AdapterLogic.getRootProperty(((InventoryBridge)((Object)this)).bridge$getAdapter(), property, key);
        }
        return this.parent().getProperty(this, property, key);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Inventory child, Class<T> property) {
        Object key = AbstractInventoryProperty.getDefaultKey(property);
        return this.getProperty(child, property, key);
    }

    @Override
    default public <T extends InventoryProperty<?, ?>> Optional<T> getInventoryProperty(Class<T> property) {
        Object key = AbstractInventoryProperty.getDefaultKey(property);
        return this.getProperty(property, key);
    }

    @Override
    default public Iterator<Inventory> iterator() {
        return new InventoryIterator(((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens(), ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric(), this);
    }

    @Override
    @Deprecated
    default public void setMaxStackSize(int size) {
        throw new UnsupportedOperationException("This inventory does not support stack limit adjustment");
    }

    @Override
    @Deprecated
    default public <T extends Inventory> T first() {
        return (T)this.iterator().next();
    }

    @Override
    @Deprecated
    default public <T extends Inventory> T next() {
        return (T)new EmptyInventoryImpl(this);
    }

    @Override
    default public <T extends Inventory> T query(QueryOperation<?> ... queries) {
        return (T)Query.compile(((InventoryBridge)((Object)this)).bridge$getAdapter(), queries).execute();
    }

    @Override
    default public Inventory intersect(Inventory inventory) {
        return Query.compile(((InventoryBridge)((Object)this)).bridge$getAdapter(), new SlotLensQueryOperation((ImmutableSet<Inventory>)ImmutableSet.of((Object)inventory))).execute();
    }

    @Override
    default public Inventory union(Inventory inventory) {
        CompoundLens.Builder lensBuilder = CompoundLens.builder().add(((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getRootLens());
        CompoundFabric fabric = new CompoundFabric(((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric(), ((InventoryAdapter)((Object)inventory)).bridge$getFabric());
        CompoundSlotProvider provider = new CompoundSlotProvider().add(((InventoryBridge)((Object)this)).bridge$getAdapter());
        for (Object inv : inventory) {
            lensBuilder.add(((InventoryAdapter)inv).bridge$getRootLens());
            provider.add((InventoryAdapter)inv);
        }
        CompoundLens lens = lensBuilder.build(provider);
        InventoryAdapter compoundAdapter = lens.getAdapter(fabric, this);
        return Query.compile(compoundAdapter, new SlotLensQueryOperation((ImmutableSet<Inventory>)ImmutableSet.of((Object)((Inventory)((Object)compoundAdapter))))).execute();
    }

    @Override
    default public boolean containsInventory(Inventory inventory) {
        Inventory result = Query.compile(((InventoryBridge)((Object)this)).bridge$getAdapter(), new LensQueryOperation(((InventoryAdapter)((Object)inventory)).bridge$getRootLens())).execute();
        return result.capacity() == inventory.capacity() && ((InventoryAdapter)((Object)result)).bridge$getRootLens() == ((InventoryAdapter)((Object)inventory)).bridge$getRootLens();
    }

    @Override
    default public InventoryArchetype getArchetype() {
        return InventoryArchetypes.UNKNOWN;
    }

    @Override
    default public <T extends Inventory> Iterable<T> slots() {
        return SlotCollectionIterator.of(this, ((InventoryBridge)((Object)this)).bridge$getAdapter());
    }

    public static interface WithClear
    extends DefaultImplementedAdapterInventory {
        @Override
        default public void clear() {
            ((InventoryBridge)((Object)this)).bridge$getAdapter().bridge$getFabric().fabric$clear();
        }
    }
}

