/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.api.text.title;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.api.text.TextBridge;
import org.spongepowered.common.bridge.text.TitleBridge;

@Mixin(value={Title.class}, remap=false)
public abstract class TitleMixin
implements TitleBridge {
    @Shadow
    @Final
    Optional<Text> title;
    @Shadow
    @Final
    Optional<Text> subtitle;
    @Shadow
    @Final
    Optional<Text> actionBar;
    @Shadow
    @Final
    Optional<Integer> fadeIn;
    @Shadow
    @Final
    Optional<Integer> stay;
    @Shadow
    @Final
    Optional<Integer> fadeOut;
    @Shadow
    @Final
    boolean clear;
    @Shadow
    @Final
    boolean reset;
    private List<SPacketTitle> packets;

    @Override
    public void bridge$send(EntityPlayerMP player) {
        for (SPacketTitle packet : this.getPackets()) {
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private List<SPacketTitle> getPackets() {
        if (this.packets == null) {
            this.packets = new ArrayList<SPacketTitle>();
            if (this.clear) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.RESET, null));
            }
            if (this.reset) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.RESET, null));
            }
            if (this.fadeIn.isPresent() || this.stay.isPresent() || this.fadeOut.isPresent()) {
                this.packets.add(new SPacketTitle(this.fadeIn.orElse(20).intValue(), this.stay.orElse(60).intValue(), this.fadeOut.orElse(20).intValue()));
            }
            if (this.subtitle.isPresent()) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.SUBTITLE, ((TextBridge)((Object)this.subtitle.get())).bridge$toComponent()));
            }
            if (this.actionBar.isPresent()) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.ACTIONBAR, ((TextBridge)((Object)this.actionBar.get())).bridge$toComponent()));
            }
            if (this.title.isPresent()) {
                this.packets.add(new SPacketTitle(SPacketTitle.Type.TITLE, ((TextBridge)((Object)this.title.get())).bridge$toComponent()));
            }
        }
        return this.packets;
    }
}

