/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.launch;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import org.spongepowered.launch.gui.LaunchInfoPanel;

public class Main {
    private static final File JAR = Main.getJar();
    public static final String JAR_NAME = Main.getJarName();
    private static Attributes manifestAttributes = null;

    public static void main(String[] argv) {
        if (System.console() == null && !Main.checkHeadlessState()) {
            Main.displayGraphicalMessage();
            return;
        }
        Main.printHeader();
        Main.printUsage();
    }

    private static void displayGraphicalMessage() {
        JOptionPane messagePane = new JOptionPane(new LaunchInfoPanel(), -1, -1);
        messagePane.setBorder(new EmptyBorder(0, 0, 20, 0));
        String dialogTitle = "Cannot start this jar directly - " + Main.getManifestAttribute("Implementation-Version", "DEV");
        JDialog dialog = messagePane.createDialog(null, dialogTitle);
        try {
            dialog.setIconImage(ImageIO.read(LaunchInfoPanel.class.getResourceAsStream("sponge_icon.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private static void printHeader() {
        System.out.printf("\n%s v%s for Minecraft Forge %s\n   implementing %s version %s\n", Main.getManifestAttribute("Implementation-Name", "Sponge"), Main.getManifestAttribute("Implementation-Version", "DEV"), Main.getManifestAttribute("TargetForgeBuild", ""), Main.getManifestAttribute("Specification-Name", "SpongeAPI"), Main.getManifestAttribute("Specification-Version", "DEV"));
    }

    private static boolean checkHeadlessState() {
        try {
            Class<?> clGraphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment");
            Method mdIsHeadless = clGraphicsEnvironment.getDeclaredMethod("isHeadless", new Class[0]);
            return (Boolean)mdIsHeadless.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static void printUsage() {
        Scanner help = new Scanner(Main.class.getResourceAsStream("help.txt")).useDelimiter("\\Z");
        System.out.print(help.next().replace("${jarfile}", JAR_NAME));
    }

    private static File getJar() {
        try {
            File jar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (jar.isFile()) {
                return jar;
            }
        }
        catch (IllegalArgumentException ex) {
            try {
                File jar;
                String uriFull = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
                int bangPos = uriFull.lastIndexOf(33);
                if (bangPos > -1 && uriFull.startsWith("jar:") && (jar = new File(URI.create(uriFull.substring(4, bangPos)))).isFile()) {
                    return jar;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getJarName() {
        return JAR != null ? JAR.getName() : "sponge.jar";
    }

    public static String getManifestAttribute(String key, String defaultValue) {
        if (JAR == null) {
            return defaultValue;
        }
        Attributes manifestAttributes = Main.getManifestAttributes();
        return manifestAttributes != null ? manifestAttributes.getValue(key) : defaultValue;
    }

    private static Attributes getManifestAttributes() {
        if (manifestAttributes == null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(JAR);
                manifestAttributes = jarFile.getManifest().getMainAttributes();
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return manifestAttributes;
    }
}

