/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.client;

import cf.terminator.laggoggles.api.event.LagGogglesEvent;
import cf.terminator.laggoggles.client.ClientConfig;
import cf.terminator.laggoggles.client.gui.GuiProfile;
import cf.terminator.laggoggles.client.gui.LagOverlayGui;
import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.packet.SPacketScanResult;
import cf.terminator.laggoggles.profiler.ProfileManager;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.util.Calculations;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ScanResultHandler
implements IMessageHandler<SPacketScanResult, IMessage> {
    private ArrayList<ObjectData> builder = new ArrayList();

    public IMessage onMessage(SPacketScanResult message, MessageContext ctx) {
        long tickCount = message.tickCount > 0L ? message.tickCount : 1L;
        for (ObjectData objectData : message.DATA) {
            if (!(Calculations.muPerTickCustomTotals((Long)objectData.getValue(ObjectData.Entry.NANOS), tickCount) >= (double)ClientConfig.MINIMUM_AMOUNT_OF_MICROSECONDS_THRESHOLD)) continue;
            this.builder.add(objectData);
        }
        if (!message.hasMore) {
            ProfileResult result = new ProfileResult(message.startTime, message.endTime, tickCount, message.side, message.type);
            result.addAll(this.builder);
            result.lock();
            this.builder = new ArrayList();
            ProfileManager.LAST_PROFILE_RESULT.set(result);
            LagOverlayGui.create(result);
            LagOverlayGui.show();
            GuiProfile.update();
            MinecraftForge.EVENT_BUS.post((Event)new LagGogglesEvent.ReceivedFromServer(result));
        }
        return null;
    }
}

