/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridProcessingTransfer
extends MessageHandlerPlayerToServer<MessageGridProcessingTransfer>
implements IMessage {
    private Collection<ItemStack> inputs;
    private Collection<ItemStack> outputs;
    private Collection<FluidStack> fluidInputs;
    private Collection<FluidStack> fluidOutputs;

    public MessageGridProcessingTransfer() {
    }

    public MessageGridProcessingTransfer(Collection<ItemStack> inputs, Collection<ItemStack> outputs, Collection<FluidStack> fluidInputs, Collection<FluidStack> fluidOutputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.inputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.inputs.add(StackUtils.readItemStack(buf));
        }
        size = buf.readInt();
        this.outputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.outputs.add(StackUtils.readItemStack(buf));
        }
        size = buf.readInt();
        this.fluidInputs = new ArrayList<FluidStack>(size);
        for (i = 0; i < size; ++i) {
            this.fluidInputs.add(StackUtils.readFluidStack(buf));
        }
        size = buf.readInt();
        this.fluidOutputs = new ArrayList<FluidStack>(size);
        for (i = 0; i < size; ++i) {
            this.fluidOutputs.add(StackUtils.readFluidStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inputs.size());
        for (ItemStack itemStack : this.inputs) {
            StackUtils.writeItemStack(buf, itemStack);
        }
        buf.writeInt(this.outputs.size());
        for (ItemStack itemStack : this.outputs) {
            StackUtils.writeItemStack(buf, itemStack);
        }
        buf.writeInt(this.fluidInputs.size());
        for (FluidStack fluidStack : this.fluidInputs) {
            StackUtils.writeFluidStack(buf, fluidStack);
        }
        buf.writeInt(this.fluidOutputs.size());
        for (FluidStack fluidStack : this.fluidOutputs) {
            StackUtils.writeFluidStack(buf, fluidStack);
        }
    }

    @Override
    public void handle(MessageGridProcessingTransfer message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && (grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getGridType() == GridType.PATTERN) {
            ItemHandlerBase handler = ((NetworkNodeGrid)grid).getProcessingMatrix();
            FluidInventory handlerFluid = ((NetworkNodeGrid)grid).getProcessingMatrixFluids();
            this.clearInputsAndOutputs(handler);
            this.clearInputsAndOutputs(handlerFluid);
            this.setInputs(handler, message.inputs);
            this.setOutputs(handler, message.outputs);
            this.setFluidInputs(handlerFluid, message.fluidInputs);
            this.setFluidOutputs(handlerFluid, message.fluidOutputs);
        }
    }

    private void clearInputsAndOutputs(ItemHandlerBase handler) {
        for (int i = 0; i < 18; ++i) {
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private void clearInputsAndOutputs(FluidInventory handler) {
        for (int i = 0; i < 18; ++i) {
            handler.setFluid(i, null);
        }
    }

    private void setInputs(ItemHandlerBase handler, Collection<ItemStack> stacks) {
        this.setSlots(handler, stacks, 0, 9);
    }

    private void setOutputs(ItemHandlerBase handler, Collection<ItemStack> stacks) {
        this.setSlots(handler, stacks, 9, 18);
    }

    private void setSlots(ItemHandlerBase handler, Collection<ItemStack> stacks, int begin, int end) {
        for (ItemStack stack : stacks) {
            handler.setStackInSlot(begin, stack);
            if (++begin < end) continue;
            break;
        }
    }

    private void setFluidInputs(FluidInventory inventory, Collection<FluidStack> stacks) {
        this.setFluidSlots(inventory, stacks, 0, 9);
    }

    private void setFluidOutputs(FluidInventory inventory, Collection<FluidStack> stacks) {
        this.setFluidSlots(inventory, stacks, 9, 18);
    }

    private void setFluidSlots(FluidInventory inventory, Collection<FluidStack> stacks, int begin, int end) {
        for (FluidStack stack : stacks) {
            inventory.setFluid(begin, stack.copy());
            if (++begin < end) continue;
            break;
        }
    }
}

