/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAssembler
extends TileEntityMultiblockMetal<TileEntityAssembler, IMultiblockRecipe>
implements IEBlockInterfaces.IGuiTile,
ConveyorHandler.IConveyorAttachable {
    public boolean[] computerOn = new boolean[3];
    public boolean isComputerControlled = false;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)21, (Object)ItemStack.field_190927_a);
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public boolean recursiveIngredients = false;
    IItemHandler insertionHandler = new IEInventoryHandler(18, (IIEInventory)this, 0, true, false);
    IItemHandler extractionHandler = new IEInventoryHandler(3, (IIEInventory)this, 18, false, true);

    public TileEntityAssembler() {
        super(MultiblockAssembler.instance, new int[]{3, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        byte cOn;
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        this.recursiveIngredients = nbt.func_74767_n("recursiveIngredients");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.func_150295_c("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
        boolean bl = this.isComputerControlled = ((cOn = nbt.func_74771_c("computerControlled")) & 1) != 0;
        if (this.isComputerControlled) {
            for (int i = 0; i < 3; ++i) {
                this.computerOn[i] = (cOn & 2 << i) != 0;
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("recursiveIngredients", this.recursiveIngredients);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.func_74782_a("pattern" + iPattern, (NBTBase)patternList);
            }
        }
        if (this.isComputerControlled) {
            byte cOn = 1;
            for (int i = 0; i < 3; ++i) {
                if (!this.computerOn[i]) continue;
                cOn = (byte)(cOn | 2 << i);
            }
            nbt.func_74774_a("computerControlled", cOn);
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        block5: {
            block3: {
                int id;
                block4: {
                    if (!message.func_74764_b("buttonID")) break block3;
                    id = message.func_74762_e("buttonID");
                    if (id < 0 || id >= this.patterns.length) break block4;
                    CrafterPatternInventory pattern = this.patterns[id];
                    for (int i = 0; i < pattern.inv.size(); ++i) {
                        pattern.inv.set(i, (Object)ItemStack.field_190927_a);
                    }
                    break block5;
                }
                if (id != 3) break block5;
                this.recursiveIngredients = !this.recursiveIngredients;
                break block5;
            }
            if (message.func_74764_b("patternSync")) {
                int r = message.func_74762_e("recipe");
                NBTTagList list = message.func_150295_c("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound itemTag = list.func_150305_b(i);
                    pattern.inv.set(itemTag.func_74762_e("slot"), (Object)new ItemStack(itemTag));
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF)) {
            return;
        }
        boolean update = false;
        NonNullList[] outputBuffer = new NonNullList[this.patterns.length];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            if (this.isComputerControlled && !this.computerOn[p] || ((ItemStack)pattern.inv.get(9)).func_190926_b() || !this.canOutput((ItemStack)pattern.inv.get(9), p)) continue;
            ItemStack output = ((ItemStack)pattern.inv.get(9)).func_77946_l();
            ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
            for (NonNullList bufferedStacks : outputBuffer) {
                if (bufferedStacks == null) continue;
                for (ItemStack stack : bufferedStacks) {
                    if (stack.func_190926_b()) continue;
                    availableStacks.add(stack);
                }
            }
            for (ItemStack stack : this.inventory) {
                if (stack.func_190926_b()) continue;
                availableStacks.add(stack);
            }
            int consumed = Config.IEConfig.Machines.assembler_consumption;
            AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
            AssemblerHandler.RecipeQuery[] queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv);
            if (queries == null || this.energyStorage.extractEnergy(consumed, true) != consumed || !this.consumeIngredients(queries, availableStacks, false, null)) continue;
            this.energyStorage.extractEnergy(consumed, false);
            NonNullList outputList = NonNullList.func_191196_a();
            outputList.add((Object)output);
            NonNullList gridItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            this.consumeIngredients(queries, availableStacks, true, (NonNullList<ItemStack>)gridItems);
            NonNullList remainingItems = pattern.recipe.func_179532_b(Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, (NonNullList<ItemStack>)gridItems));
            for (ItemStack rem : remainingItems) {
                if (rem.func_190926_b()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer[p] = outputList;
            update = true;
        }
        BlockPos outputPos = this.func_174877_v().func_177967_a(this.facing, 2);
        TileEntity inventoryTile = Utils.getExistingTileEntity(this.field_145850_b, outputPos);
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].size() <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].size(); ++iOutput) {
                ItemStack output = (ItemStack)outputBuffer[buffer].get(iOutput);
                if (output.func_190926_b() || output.func_190916_E() <= 0 || !this.isRecipeIngredient(output, buffer) && inventoryTile != null && ((output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d())).func_190926_b() || output.func_190916_E() <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (((ItemStack)this.inventory.get(18 + buffer)).func_190926_b() && free < 0) {
                        free = 18 + buffer;
                    } else if (!((ItemStack)this.inventory.get(18 + buffer)).func_190926_b() && OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + buffer)), (boolean)true) && ((ItemStack)this.inventory.get(18 + buffer)).func_190916_E() + output.func_190916_E() <= ((ItemStack)this.inventory.get(18 + buffer)).func_77976_d()) {
                        ((ItemStack)this.inventory.get(18 + buffer)).func_190917_f(output.func_190916_E());
                        free = -1;
                        continue;
                    }
                } else {
                    for (int i = 0; i < this.inventory.size(); ++i) {
                        if (((ItemStack)this.inventory.get(i)).func_190926_b() && free < 0) {
                            free = i;
                            continue;
                        }
                        if (((ItemStack)this.inventory.get(i)).func_190926_b() || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(i)), (boolean)true) || ((ItemStack)this.inventory.get(i)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(i)).func_77976_d()) continue;
                        ((ItemStack)this.inventory.get(i)).func_190917_f(output.func_190916_E());
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory.set(free, (Object)output.func_77946_l());
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient((ItemStack)this.inventory.get(18 + i), i) || inventoryTile == null) continue;
            this.inventory.set(18 + i, (Object)Utils.insertStackIntoInventory(inventoryTile, (ItemStack)this.inventory.get(18 + i), this.facing.func_176734_d()));
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    public boolean consumeIngredients(AssemblerHandler.RecipeQuery[] queries, ArrayList<ItemStack> itemStacks, boolean doConsume, @Nullable NonNullList<ItemStack> gridItems) {
        if (!doConsume) {
            ArrayList<ItemStack> dupeList = new ArrayList<ItemStack>(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                dupeList.add(itemStack.func_77946_l());
            }
            itemStacks = dupeList;
        }
        for (int i = 0; i < queries.length; ++i) {
            AssemblerHandler.RecipeQuery recipeQuery = queries[i];
            if (recipeQuery == null || recipeQuery.query == null) continue;
            FluidStack fluidStack = recipeQuery.query instanceof FluidStack ? (FluidStack)recipeQuery.query : (recipeQuery.query instanceof IngredientStack && ((IngredientStack)recipeQuery.query).fluid != null ? ((IngredientStack)recipeQuery.query).fluid : null);
            int querySize = recipeQuery.querySize;
            if (fluidStack != null) {
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fluidStack)) continue;
                    hasFluid = true;
                    if (!doConsume) break;
                    tank.drain(fluidStack.amount, true);
                    break;
                }
                if (hasFluid) continue;
                querySize = 1;
            }
            Iterator<Object> it = itemStacks.iterator();
            while (it.hasNext()) {
                ItemStack next = (ItemStack)it.next();
                if (next.func_190926_b() || !ApiUtils.stackMatchesObject(next, recipeQuery.query, true)) continue;
                int taken = Math.min(querySize, next.func_190916_E());
                ItemStack forGrid = next.func_77979_a(taken);
                if (gridItems != null) {
                    gridItems.set(i, (Object)forGrid);
                }
                if (next.func_190916_E() <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (((ItemStack)this.inventory.get(18 + iPattern)).func_190926_b()) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)output, (ItemStack)((ItemStack)this.inventory.get(18 + iPattern)), (boolean)true) && Utils.compareItemNBT(output, (ItemStack)this.inventory.get(18 + iPattern)) && ((ItemStack)this.inventory.get(18 + iPattern)).func_190916_E() + output.func_190916_E() <= ((ItemStack)this.inventory.get(18 + iPattern)).func_77976_d();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot - 1 < this.patterns.length || this.recursiveIngredients) {
            int p;
            int n = p = this.recursiveIngredients ? 0 : slot;
            while (p < this.patterns.length) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).func_190926_b()) continue;
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack, (boolean)false)) {
                        return true;
                    }
                    if (((ItemStack)pattern.inv.get(i)).func_77973_b() != stack.func_77973_b() || ((ItemStack)pattern.inv.get(i)).func_77981_g() || !((ItemStack)pattern.inv.get(i)).func_77984_f()) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c < 9 || this.field_174879_c == 10 || this.field_174879_c == 13 || this.field_174879_c == 16 || this.field_174879_c == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.NORTH) {
            zMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.NORTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.SOUTH) {
            zMax = 0.75f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.EAST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.WEST) {
            xMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.WEST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.EAST) {
            xMax = 0.75f;
        }
        if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.EAST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.WEST) {
            zMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.WEST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.EAST) {
            zMax = 0.8125f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.NORTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.SOUTH) {
            xMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.NORTH) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{22};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{3, 5};
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 1 && w == 1 && l != 1 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.facing);
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, -1);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (!output.func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (this.field_174879_c == 10 && facing == this.facing.func_176734_d() || this.field_174879_c == 16 && facing == this.facing) && this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAssembler master = (TileEntityAssembler)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 10 && facing == this.facing.func_176734_d()) {
                return (T)master.insertionHandler;
            }
            if (this.field_174879_c == 16 && facing == this.facing) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 5;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityAssembler master = (TileEntityAssembler)this.master();
        if (master != null && this.field_174879_c == 1 && (side == null || side == this.facing.func_176734_d())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    @Override
    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 16) {
            return new EnumFacing[]{this.facing};
        }
        return new EnumFacing[0];
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public NonNullList<ItemStack> inv = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 10;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.inv) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return (ItemStack)this.inv.get(slot);
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (slot < 9 && !stack.func_190926_b()) {
                if (stack.func_190916_E() <= amount) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv.set(slot, (Object)stack);
                if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                    stack.func_190920_e(this.func_70297_j_());
                }
            }
            this.recalculateOutput();
        }

        public void func_174888_l() {
            for (int i = 0; i < this.inv.size(); ++i) {
                this.inv.set(i, (Object)ItemStack.field_190927_a);
            }
        }

        public void recalculateOutput() {
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            this.recipe = Utils.findRecipe(invC, this.tile.func_145831_w());
            this.inv.set(9, (Object)(this.recipe != null ? this.recipe.func_77572_b(invC) : ItemStack.field_190927_a));
        }

        public ArrayList<ItemStack> getTotalPossibleOutputs() {
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(((ItemStack)this.inv.get(9)).func_77946_l());
            for (int i = 0; i < 9; ++i) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inv.get(i)));
                if (fs == null) continue;
                boolean hasFluid = false;
                for (FluidTank tank : this.tile.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (!hasFluid) continue;
            }
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            for (ItemStack ss : this.recipe.func_179532_b(invC)) {
                if (ss.func_190926_b()) continue;
                outputList.add(ss);
            }
            return outputList;
        }

        public String func_70005_c_() {
            return "IECrafterPattern";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.size(); ++i) {
                if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                ((ItemStack)this.inv.get(i)).func_77955_b(itemTag);
                list.func_74742_a((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.inv.set(slot, (Object)new ItemStack(itemTag));
            }
            this.recalculateOutput();
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.func_70005_c_());
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }
    }
}

