/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemEngineerGoggles;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserRelayUpgrade;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserWrench;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLaserRelay
extends BlockContainerBase
implements IHudDisplay {
    private static final float F = 0.0625f;
    private static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.625, 0.875);
    private static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.125, 0.375, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.125, 0.375, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.125, 0.125, 0.625, 0.875, 0.875);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.625);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.375, 0.125, 0.125, 1.0, 0.875, 0.875);
    private final Type type;

    public BlockLaserRelay(String name, Type type) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.type = type;
        if (this.type.ordinal() == 0) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        if (player != null && world != null && StackUtil.isValid(stack) && pos != null && (state = event.getWorld().func_180495_p(pos)) != null && state.func_177230_c() instanceof BlockLaserRelay && player.func_70093_af()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.func_176201_c(state)) {
            case 1: {
                return AABB_UP;
            }
            case 2: {
                return AABB_NORTH;
            }
            case 3: {
                return AABB_SOUTH;
            }
            case 4: {
                return AABB_WEST;
            }
            case 5: {
                return AABB_EAST;
            }
        }
        return AABB_DOWN;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase base) {
        return this.func_176203_a(side.ordinal());
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return this.func_185499_a(state, mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLaserRelay) {
            ItemStack inRelay;
            TileEntityLaserRelay relay = (TileEntityLaserRelay)tile;
            if (StackUtil.isValid(stack)) {
                if (stack.func_77973_b() instanceof ItemLaserWrench) {
                    return false;
                }
                if (stack.func_77973_b() == ConfigValues.itemCompassConfigurator) {
                    if (!world.field_72995_K) {
                        relay.onCompassAction(player);
                        Network network = relay.getNetwork();
                        if (network != null) {
                            ++network.changeAmount;
                        }
                        relay.func_70296_d();
                        relay.sendUpdate();
                    }
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemLaserRelayUpgrade && !StackUtil.isValid(inRelay = relay.inv.getStackInSlot(0))) {
                    if (!world.field_72995_K) {
                        if (!player.func_184812_l_()) {
                            player.func_184611_a(hand, StackUtil.shrink(stack, 1));
                        }
                        ItemStack set = stack.func_77946_l();
                        set.func_190920_e(1);
                        relay.inv.setStackInSlot(0, set);
                    }
                    return true;
                }
            }
            if (player.func_70093_af() && StackUtil.isValid(inRelay = relay.inv.getStackInSlot(0).func_77946_l())) {
                if (!world.field_72995_K) {
                    relay.inv.setStackInSlot(0, StackUtil.getEmpty());
                    if (!player.field_71071_by.func_70441_a(inRelay)) {
                        player.func_70099_a(inRelay, 0.0f);
                    }
                }
                return true;
            }
            if (relay instanceof TileEntityLaserRelayItemWhitelist) {
                if (!world.field_72995_K) {
                    player.openGui((Object)ActuallyAdditions.INSTANCE, GuiHandler.GuiTypes.LASER_RELAY_ITEM_WHITELIST.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        switch (this.type) {
            case ITEM: {
                return new TileEntityLaserRelayItem();
            }
            case ITEM_WHITELIST: {
                return new TileEntityLaserRelayItemWhitelist();
            }
            case ENERGY_ADVANCED: {
                return new TileEntityLaserRelayEnergyAdvanced();
            }
            case ENERGY_EXTREME: {
                return new TileEntityLaserRelayEnergyExtreme();
            }
            case FLUIDS: {
                return new TileEntityLaserRelayFluids();
            }
        }
        return new TileEntityLaserRelayEnergy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void displayHud(Minecraft minecraft, EntityPlayer player, ItemStack stack, RayTraceResult posHit, ScaledResolution resolution) {
        boolean wearing;
        if (posHit != null && posHit.func_178782_a() != null && minecraft.field_71441_e != null && ((wearing = ItemEngineerGoggles.isWearing(player)) || StackUtil.isValid(stack))) {
            TileEntity tile;
            boolean compass;
            boolean bl = compass = stack.func_77973_b() == ConfigValues.itemCompassConfigurator;
            if ((wearing || compass || stack.func_77973_b() instanceof ItemLaserWrench) && (tile = minecraft.field_71441_e.func_175625_s(posHit.func_178782_a())) instanceof TileEntityLaserRelay) {
                TileEntityLaserRelay relay = (TileEntityLaserRelay)tile;
                String strg = relay.getExtraDisplayString();
                minecraft.field_71466_p.func_175063_a(strg, (float)(resolution.func_78326_a() / 2 + 5), (float)(resolution.func_78328_b() / 2 + 5), 0xFFFFFF);
                String expl = compass ? relay.getCompassDisplayString() : TextFormatting.GRAY.toString() + TextFormatting.ITALIC + StringUtil.localizeFormatted("info.actuallyadditions.laserRelay.mode.noCompasss", StringUtil.localize(ConfigValues.itemCompassConfigurator.func_77658_a() + ".name"));
                StringUtil.drawSplitString(minecraft.field_71466_p, expl, resolution.func_78326_a() / 2 + 5, resolution.func_78328_b() / 2 + 15, Integer.MAX_VALUE, 0xFFFFFF, true);
            }
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(pos, world);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum Type {
        ENERGY_BASIC,
        ENERGY_ADVANCED,
        ENERGY_EXTREME,
        FLUIDS,
        ITEM,
        ITEM_WHITELIST;

    }
}

