/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.LongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class WorldTimeArgument
extends CommandElement {
    private static final int TICKS_IN_DAY = 24000;
    private static final HashMap<String, LongFunction<Long>> tickAliases = Maps.newHashMap();
    private static final Pattern tfh = Pattern.compile("^(\\d{1,2})[hH]$");
    private static final Pattern ampm = Pattern.compile("^(\\d{1,2})(a[m]?|p[m]?)$", 66);
    private static final Pattern ticks = Pattern.compile("^(\\d{1,5})$");
    private static final RoundUp DAWN = new RoundUp(0L);
    private static final RoundUp DAY = new RoundUp(1000L);
    private static final RoundUp NOON = new RoundUp(6000L);
    private static final RoundUp DUSK = new RoundUp(12000L);
    private static final RoundUp NIGHT = new RoundUp(14000L);
    private static final RoundUp MIDNIGHT = new RoundUp(18000L);

    public WorldTimeArgument(@Nullable Text key) {
        super(key);
    }

    private LongFunction<Long> getValue(String arg, CommandArgs args) throws ArgumentParseException {
        if (tickAliases.containsKey(arg)) {
            return tickAliases.get(arg);
        }
        Matcher m1 = tfh.matcher(arg);
        if (m1.matches()) {
            long i = Long.parseLong(m1.group(1));
            if (i > 23L || i < 0L) {
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.worldtime.24herror", new String[0]));
            }
            if ((i -= 6L) < 0L) {
                i += 24L;
            }
            long res = i * 1000L;
            return x -> res;
        }
        Matcher m2 = ampm.matcher(arg);
        if (m2.matches()) {
            int i = Integer.parseInt(m2.group(1));
            if (i > 12 || i < 1) {
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.worldtime.12herror", new String[0]));
            }
            String id = m2.group(2).toLowerCase();
            if (id.startsWith("p") && i < 12) {
                i += 12;
            } else if (id.startsWith("a") && i == 12) {
                i = 0;
            }
            if ((i -= 6) < 0) {
                i += 24;
            }
            long res = i * 1000;
            return x -> res;
        }
        if (ticks.matcher(arg).matches()) {
            long i = Long.parseLong(arg);
            if (i >= 0L && i <= 23999L) {
                return x -> i;
            }
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.worldtime.ticks", new String[0]));
        }
        throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.worldtime.error", arg));
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String arg = args.next().toLowerCase();
        return this.getValue(arg, args);
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        try {
            String a = args.peek().toLowerCase();
            return tickAliases.keySet().stream().filter(x -> x.startsWith(a)).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return new ArrayList<String>(tickAliases.keySet());
        }
    }

    static {
        tickAliases.put("dawn", DAWN);
        tickAliases.put("sunrise", DAWN);
        tickAliases.put("morning", DAY);
        tickAliases.put("day", DAY);
        tickAliases.put("daytime", DAY);
        tickAliases.put("noon", NOON);
        tickAliases.put("afternoon", NOON);
        tickAliases.put("dusk", DUSK);
        tickAliases.put("sunset", DUSK);
        tickAliases.put("evening", DUSK);
        tickAliases.put("night", NIGHT);
        tickAliases.put("midnight", MIDNIGHT);
    }

    private static class RoundUp
    implements LongFunction<Long> {
        private final long target;

        private RoundUp(long target) {
            this.target = target;
        }

        @Override
        public final Long apply(long value) {
            long remainder = value % 24000L;
            if (this.target == remainder) {
                return value;
            }
            if (this.target < remainder) {
                value += 24000L;
            }
            return value - remainder + this.target;
        }
    }
}

