/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal;

import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.math.BigDecimal;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;

public class EconHelper {
    public boolean economyServiceExists() {
        return Sponge.getServiceManager().provide(EconomyService.class).isPresent();
    }

    public String getCurrencySymbol(double cost) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        return oes.map(economyService -> economyService.getDefaultCurrency().format(BigDecimal.valueOf(cost)).toPlain()).orElseGet(() -> String.valueOf(cost));
    }

    public boolean hasBalance(Player src, double balance) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional ua = es.getOrCreateAccount(src.getUniqueId());
            return ua.isPresent() && ((UniqueAccount)ua.get()).getBalance(es.getDefaultCurrency()).doubleValue() >= balance;
        }
        return true;
    }

    public boolean withdrawFromPlayer(Player src, double cost) {
        return this.withdrawFromPlayer(src, cost, true);
    }

    public boolean withdrawFromPlayer(Player src, double cost, boolean message) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional a = es.getOrCreateAccount(src.getUniqueId());
            if (!a.isPresent()) {
                src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.noaccount", new String[0]));
                return false;
            }
            TransactionResult tr = ((UniqueAccount)a.get()).withdraw(es.getDefaultCurrency(), BigDecimal.valueOf(cost), CauseStackHelper.createCause(src));
            if (tr.getResult() == ResultType.ACCOUNT_NO_FUNDS) {
                if (message) {
                    src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.nofunds", this.getCurrencySymbol(cost)));
                }
                return false;
            }
            if (tr.getResult() != ResultType.SUCCESS) {
                src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.error", new String[0]));
                return false;
            }
            if (message) {
                src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.complete", this.getCurrencySymbol(cost)));
            }
        }
        return true;
    }

    public boolean depositInPlayer(User src, double cost) {
        return this.depositInPlayer(src, cost, true);
    }

    public boolean depositInPlayer(User src, double cost, boolean message) {
        Optional oes = Sponge.getServiceManager().provide(EconomyService.class);
        if (oes.isPresent()) {
            EconomyService es = (EconomyService)oes.get();
            Optional a = es.getOrCreateAccount(src.getUniqueId());
            if (!a.isPresent()) {
                src.getPlayer().ifPresent(x -> x.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.noaccount", new String[0])));
                return false;
            }
            TransactionResult tr = ((UniqueAccount)a.get()).deposit(es.getDefaultCurrency(), BigDecimal.valueOf(cost), CauseStackHelper.createCause(src));
            if (tr.getResult() != ResultType.SUCCESS && src.isOnline()) {
                src.getPlayer().ifPresent(x -> x.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.error", new String[0])));
                return false;
            }
            if (message && src.isOnline()) {
                src.getPlayer().ifPresent(x -> x.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cost.refund", this.getCurrencySymbol(cost))));
            }
        }
        return true;
    }
}

