/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.command;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.annotationprocessor.Store;
import io.github.nucleuspowered.nucleus.argumentparsers.NoModifiersArgument;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.CostCancellableTask;
import io.github.nucleuspowered.nucleus.internal.TimingsDummy;
import io.github.nucleuspowered.nucleus.internal.annotations.RequiresEconomy;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCommandPrefix;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCooldown;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCost;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoHelpSubcommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoTimings;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoWarmup;
import io.github.nucleuspowered.nucleus.internal.annotations.command.PermissionsFrom;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RedirectModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.SetCooldownManually;
import io.github.nucleuspowered.nucleus.internal.command.CommandBuilder;
import io.github.nucleuspowered.nucleus.internal.command.ContinueMode;
import io.github.nucleuspowered.nucleus.internal.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.internal.command.NucleusArgumentParseException;
import io.github.nucleuspowered.nucleus.internal.command.NucleusCommandException;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.core.config.WarmupConfig;
import io.github.nucleuspowered.nucleus.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.args.parsing.SingleArg;
import org.spongepowered.api.command.dispatcher.SimpleDispatcher;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Store(value="command")
public abstract class AbstractCommand<T extends CommandSource>
implements CommandCallable,
InternalServiceManagerTrait,
PermissionTrait,
MessageProviderTrait {
    private static final InputTokenizer tokeniser = InputTokenizer.quotedStrings((boolean)false);
    private static final List<ICommandInterceptor> commandInterceptors = Lists.newArrayList();
    private final boolean generateConfigEntries;
    private final boolean isAsync = this.getClass().getAnnotation(RunAsync.class) != null;
    private Timing commandTimings = TimingsDummy.DUMMY;
    private final String commandPath;
    @Nullable
    private Set<Class<? extends AbstractCommand<?>>> moduleCommands = null;
    private final Map<UUID, Instant> cooldownStore = Maps.newHashMap();
    protected final CommandPermissionHandler permissions;
    @Nullable
    private final Collection<String> additionalPermsToCheck;
    private final String[] aliases;
    private final String[] forcedAliases;
    private final Class<T> sourceType;
    private final boolean bypassWarmup;
    private final boolean generateWarmupAnyway;
    private final boolean bypassCooldown;
    private final boolean manualCooldownOnly;
    private final boolean bypassCost;
    private final boolean requiresEconomy;
    private final String configSection;
    private final boolean isRoot;
    private CommandElement argumentParser = GenericArguments.none();
    private final SimpleDispatcher dispatcher = new SimpleDispatcher(SimpleDispatcher.FIRST_DISAMBIGUATOR);
    private final UsageCommand usageCommand = new UsageCommand();
    private final Nucleus plugin;
    private final boolean hasExecutor;
    @Nullable
    private CommandBuilder builder;
    @Nullable
    private String module;
    @Nullable
    private String moduleId;
    private final String warmupKey;
    private final String cooldownKey;
    private final String costKey;
    private final Predicate<CommandSource> sourceTypePredicate;
    @Nullable
    private Optional<Text> desc;
    @Nullable
    private Optional<Text> extended;

    public static void registerInterceptor(ICommandInterceptor interceptor) {
        commandInterceptors.add((ICommandInterceptor)Preconditions.checkNotNull((Object)interceptor));
    }

    public AbstractCommand() {
        String[] nPrimary;
        ArrayList a;
        List<Class<?>> types = ClassUtil.getActualTypeArguments(this.getClass(), AbstractCommand.class);
        this.sourceType = types.isEmpty() ? CommandSource.class : types.get(0);
        this.sourceTypePredicate = this.sourceType.getClass().isAssignableFrom(CommandSource.class) ? x -> true : this.sourceType::isInstance;
        this.commandPath = this.getSubcommandOf();
        RegisterCommand rc = this.getClass().getAnnotation(RegisterCommand.class);
        this.isRoot = rc == null || rc.subcommandOf().equals(AbstractCommand.class);
        this.hasExecutor = rc != null && rc.hasExecutor();
        ArrayList force = rc == null ? Lists.newArrayList() : Lists.newArrayList((Object[])rc.rootAliasRegister());
        ArrayList arrayList = a = rc == null ? Lists.newArrayList() : Lists.newArrayList((Object[])rc.value());
        if (!(this.getClass().isAnnotationPresent(NoCommandPrefix.class) || a.isEmpty() || !this.isRoot || a.contains(nPrimary = "n" + ((String)a.get(0)).toLowerCase()) || force.contains(nPrimary))) {
            force.add(nPrimary);
        }
        this.aliases = a.toArray(new String[0]);
        this.forcedAliases = force.toArray(new String[0]);
        this.permissions = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(this.getClass());
        if (this.getClass().isAnnotationPresent(PermissionsFrom.class)) {
            this.additionalPermsToCheck = Lists.newArrayList();
            for (String p : this.getClass().getAnnotation(PermissionsFrom.class).requiresSuffix()) {
                this.additionalPermsToCheck.add(this.permissions.getPermissionWithSuffix(p));
            }
        } else {
            this.additionalPermsToCheck = null;
        }
        if (this.getClass().isAnnotationPresent(NoModifiers.class)) {
            this.bypassWarmup = true;
            this.generateWarmupAnyway = false;
            this.bypassCooldown = true;
            this.bypassCost = true;
            this.manualCooldownOnly = true;
        } else {
            NoWarmup w = this.getClass().getAnnotation(NoWarmup.class);
            this.bypassWarmup = w != null;
            this.generateWarmupAnyway = !this.bypassWarmup || w.generateConfigEntry();
            this.bypassCooldown = this.getClass().getAnnotation(NoCooldown.class) != null;
            this.bypassCost = this.getClass().getAnnotation(NoCost.class) != null;
            this.manualCooldownOnly = this.getClass().getAnnotation(SetCooldownManually.class) != null;
        }
        RedirectModifiers cca = this.getClass().getAnnotation(RedirectModifiers.class);
        String configSect = this.commandPath.isEmpty() || !this.commandPath.contains(".") ? "" : this.commandPath.replaceAll("\\.[^.]+$", ".");
        this.generateConfigEntries = cca == null || cca.requireGeneration();
        this.configSection = configSect + (cca == null ? this.getAliases()[0].toLowerCase() : cca.value().toLowerCase());
        this.warmupKey = "nucleus." + this.configSection + ".warmup";
        this.cooldownKey = "nucleus." + this.configSection + ".cooldown";
        this.costKey = "nucleus." + this.configSection + ".cost";
        this.requiresEconomy = this.getClass().isAnnotationPresent(RequiresEconomy.class);
        if (!this.getClass().isAnnotationPresent(NoTimings.class)) {
            try {
                this.commandTimings = Timings.of((Object)Nucleus.getNucleus(), (String)("Command - /" + this.commandPath.replace(".", " ")));
            }
            catch (Throwable e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                this.commandTimings = TimingsDummy.DUMMY;
            }
        }
        this.plugin = Nucleus.getNucleus();
    }

    public boolean canLoad() {
        return true;
    }

    private String getSubcommandOf() {
        StringBuilder sb = new StringBuilder();
        this.getSubcommandOf(this.getClass(), sb, false);
        return sb.toString();
    }

    private void getSubcommandOf(Class<? extends AbstractCommand> c, StringBuilder sb, boolean appendPeriod) {
        RegisterCommand rc = c.getAnnotation(RegisterCommand.class);
        if (!Modifier.isAbstract(rc.subcommandOf().getModifiers()) && rc.subcommandOf() != this.getClass()) {
            this.getSubcommandOf(rc.subcommandOf(), sb, true);
        }
        sb.append(rc.value()[0]);
        if (appendPeriod) {
            sb.append(".");
        }
    }

    final void setModuleCommands(Set<Class<? extends AbstractCommand<?>>> moduleCommands) {
        Preconditions.checkState((this.moduleCommands == null ? 1 : 0) != 0);
        this.moduleCommands = moduleCommands;
    }

    final void setCommandBuilder(CommandBuilder builder) {
        this.builder = builder;
    }

    public final void postInit() {
        Preconditions.checkNotNull((Object)this.getAliases());
        Preconditions.checkArgument((this.getAliases().length > 0 ? 1 : 0) != 0);
        this.argumentParser = GenericArguments.seq((CommandElement[])this.getArguments());
        this.createChildCommands();
        this.afterPostInit();
        this.permissionsToRegister().forEach(this.permissions::registerPermission);
        this.permissionSuffixesToRegister().forEach(this.permissions::registerPermissionSuffix);
    }

    protected void afterPostInit() {
    }

    protected boolean allowFallback(CommandSource source, CommandArgs args, CommandContext context) {
        return true;
    }

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        CommandArgs args = new CommandArgs(arguments, tokeniser.tokenize(arguments, false));
        return this.process(source, this.commandPath.replace(".", " "), arguments, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult process(CommandSource source, String command, String arguments, CommandArgs args) throws CommandException {
        T castedSource;
        ArrayList thrown = Lists.newArrayList();
        CommandContext context = new CommandContext();
        try {
            if (args.hasNext() && this.dispatcher.containsAlias(args.peek())) {
                CommandArgs.Snapshot state = args.getSnapshot();
                String next = args.next();
                try {
                    CommandCallable callable = ((CommandMapping)this.dispatcher.get(next.toLowerCase()).get()).getCallable();
                    if (callable instanceof AbstractCommand) {
                        CommandResult commandResult = ((AbstractCommand)callable).process(source, command + " " + next, arguments, args);
                        return commandResult;
                    }
                    CommandResult commandResult = callable.process(source, arguments);
                    return commandResult;
                }
                catch (NucleusCommandException e) {
                    thrown.addAll(e.getExceptions());
                    if (!e.isAllowFallback()) {
                        throw e;
                    }
                }
                catch (CommandException e) {
                    thrown.add(Tuple.of((Object)(command + " " + next), (Object)((Object)e)));
                }
                finally {
                    args.applySnapshot(state);
                }
            }
            if (this.requiresEconomy && !this.plugin.getEconHelper().economyServiceExists()) {
                source.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.economyrequired", new String[0]));
                return CommandResult.empty();
            }
            castedSource = this.checkSourceType(source);
            if (!this.testPermissionOnSubject((Subject)castedSource)) {
                throw new CommandPermissionException();
            }
            if (!this.hasExecutor) {
                if (!thrown.isEmpty()) throw new NucleusCommandException(thrown);
                return this.usageCommand.process(source, "", args.nextIfPresent().map(String::toLowerCase).orElse(null));
            }
            this.argumentParser.parse(source, args, context);
            if (args.hasNext()) {
                thrown.add(Tuple.of((Object)command, (Object)((Object)new NucleusArgumentParseException(Text.of((Object[])new Object[]{TextColors.RED, "Too many arguments"}), args.getRaw(), args.getRawPosition(), (Text)Text.of((String)this.getSimpleUsage(source)), this.getChildrenUsage(source).orElse(null), true))));
                throw new NucleusCommandException(thrown, this.allowFallback(source, args, context));
            }
        }
        catch (NucleusCommandException nce) {
            throw nce;
        }
        catch (ArgumentParseException ape) {
            thrown.add(Tuple.of((Object)command, (Object)((Object)NucleusArgumentParseException.from(ape, (Text)Text.of((String)this.getSimpleUsage(source)), this.getChildrenUsage(source).orElse(null)))));
            throw new NucleusCommandException(thrown, this.allowFallback(source, args, context));
        }
        catch (CommandException ex) {
            thrown.add(Tuple.of((Object)command, (Object)((Object)ex)));
            throw new NucleusCommandException(thrown, this.allowFallback(source, args, context));
        }
        catch (Throwable throwable) {
            String m = throwable.getMessage() == null ? "null" : throwable.getMessage();
            thrown.add(Tuple.of((Object)command, (Object)((Object)new CommandException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.exception.unexpected", m), throwable))));
            throwable.printStackTrace();
            throw new NucleusCommandException(thrown, this.allowFallback(source, args, context));
        }
        try {
            CommandResult commandResult;
            this.commandTimings.startTimingIfSync();
            ContinueMode mode = this.preProcessChecks(castedSource, context);
            if (!mode.cont) {
                CommandResult m = mode.returnType;
                return m;
            }
            if (castedSource instanceof Player) {
                ContinueMode cm = this.runChecks((Player)castedSource, context);
                if (!cm.cont) {
                    commandResult = cm.returnType;
                    return commandResult;
                }
            }
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            if (this.isAsync) {
                Nucleus.getNucleus().getLogger().debug("Running " + this.getClass().getName() + " in async mode.");
                Sponge.getScheduler().createAsyncExecutor((Object)Nucleus.getNucleus()).execute(() -> this.onExecute(castedSource, context, cause));
                commandResult = CommandResult.success();
                return commandResult;
            }
            commandResult = this.onExecute(castedSource, context, cause);
            return commandResult;
        }
        finally {
            this.commandTimings.stopTimingIfSync();
        }
    }

    private CommandResult onExecute(T source, CommandContext context, Cause cause) {
        try {
            return this.startExecute(source, context, cause);
        }
        catch (TextMessageException ex) {
            if (this.plugin.isDebugMode()) {
                ex.printStackTrace();
            }
            source.sendMessage(this.plugin.getMessageProvider().getTextMessageWithTextFormat("command.exception.unexpected", ex.getText()));
            return CommandResult.empty();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String m = throwable.getMessage() == null ? "null" : throwable.getMessage();
            source.sendMessage(this.plugin.getMessageProvider().getTextMessageWithFormat("command.exception.unexpected", m));
            return CommandResult.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult startExecute(T src, CommandContext args, Cause cause) throws Exception {
        CommandResult cr;
        boolean isSuccess = false;
        try {
            commandInterceptors.forEach(x -> x.onPreCommand((Class<? extends AbstractCommand<?>>)this.getClass(), (CommandSource)src, args));
            cr = this.executeCommand(src, args, cause);
            isSuccess = cr.getSuccessCount().orElse(0) > 0;
        }
        catch (ReturnMessageException e) {
            Text t = e.getText();
            src.sendMessage(t == null ? NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.error", new String[0]) : t);
            cr = CommandResult.empty();
        }
        finally {
            if (src instanceof Player) {
                Player p = (Player)src;
                if (isSuccess) {
                    if (!this.manualCooldownOnly) {
                        this.setCooldown(p, args);
                    }
                } else {
                    double cost = this.getCost((CommandSource)p, args);
                    if (cost > 0.0) {
                        Sponge.getScheduler().createSyncExecutor((Object)this.plugin).execute(() -> this.plugin.getEconHelper().depositInPlayer((User)p, cost));
                    }
                }
            }
        }
        for (ICommandInterceptor x2 : commandInterceptors) {
            x2.onPostCommand((Class<? extends AbstractCommand<?>>)this.getClass(), (CommandSource)src, args, cr);
        }
        return cr;
    }

    public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) throws CommandException {
        ArrayList singleArgs = Lists.newArrayList((Iterable)tokeniser.tokenize(arguments, false));
        if (arguments.isEmpty() || arguments.endsWith(" ")) {
            singleArgs.add(new SingleArg("", arguments.length() - 1, arguments.length() - 1));
        }
        CommandArgs args = new CommandArgs(arguments, (List)singleArgs);
        ArrayList options = Lists.newArrayList();
        CommandContext context = new CommandContext();
        context.putArg("tab-complete-50456", (Object)true);
        CommandArgs.Snapshot state = args.getSnapshot();
        options.addAll(this.dispatcher.getSuggestions(source, arguments, targetPosition));
        args.applySnapshot(state);
        options.addAll(this.argumentParser.complete(source, args, context));
        return options.stream().distinct().collect(Collectors.toList());
    }

    public boolean testPermission(CommandSource source) {
        return this.testPermissionOnSubject((Subject)source);
    }

    private boolean testPermissionOnSubject(Subject source) {
        if (this.additionalPermsToCheck != null && !this.additionalPermsToCheck.stream().allMatch(x -> this.hasPermission(source, (String)x))) {
            return false;
        }
        return this.permissions.isPassthrough() || this.permissions.testBase(source);
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        if (this.desc == null) {
            this.desc = Optional.of(Text.of((String)this.getDescription()));
        }
        return this.desc;
    }

    public Optional<Text> getHelp(CommandSource source) {
        if (this.desc == null) {
            this.desc = Optional.of(Text.of((String)this.getDescription()));
        }
        if (this.extended == null) {
            String r = this.getExtendedDescription();
            this.extended = r.isEmpty() ? this.desc : this.desc.map(text -> Optional.of(Text.of((Object[])new Object[]{text, Text.NEW_LINE, Util.SPACE, Text.NEW_LINE, Text.of((String)r)}))).orElseGet(() -> Optional.of(Text.of((String)r)));
        }
        return this.extended;
    }

    public Text getUsage(CommandSource source) {
        return Text.of((String)this.getUsageString(source));
    }

    public String[] getAliases() {
        return Arrays.copyOf(this.aliases, this.aliases.length);
    }

    public String[] getRootCommandAliases() {
        return Arrays.copyOf(this.forcedAliases, this.forcedAliases.length);
    }

    protected abstract CommandResult executeCommand(T var1, CommandContext var2, Cause var3) throws Exception;

    public String getCommandPath() {
        return this.commandPath;
    }

    public String getConfigSection() {
        return this.configSection;
    }

    public String getDescription() {
        return this.getFromCommandKey("desc");
    }

    public String getExtendedDescription() {
        return this.getFromCommandKey("extended");
    }

    private String getFromCommandKey(String type) {
        String key = String.format("%s.%s", this.commandPath, type);
        try {
            return NucleusPlugin.getNucleus().getCommandMessageProvider().getMessageWithFormat(key, new String[0]);
        }
        catch (Exception e) {
            if (Nucleus.getNucleus().isDebugMode()) {
                Nucleus.getNucleus().getLogger().debug("Could not get command resource key " + key);
            }
            return "";
        }
    }

    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return Maps.newHashMap();
    }

    protected Map<String, PermissionInformation> permissionsToRegister() {
        return Maps.newHashMap();
    }

    public final CommandPermissionHandler getPermissionHandler() {
        return this.permissions;
    }

    public final String getUsageString(CommandSource source) {
        StringBuilder builder = new StringBuilder("/").append(this.getCommandPath().replaceAll("\\.", " ")).append(" ");
        this.dispatcher.getPrimaryAliases().stream().map(x -> this.dispatcher.get(x, source).orElse(null)).filter(x -> x != null && x.getCallable().testPermission(source)).forEach(x -> builder.append(x.getPrimaryAlias()).append("|"));
        return builder.append(this.argumentParser.getUsage(source).toPlain().replaceAll("\\?\\|", "")).toString();
    }

    public final String getSimpleUsage(CommandSource source) {
        return "/" + this.getCommandPath().replaceAll("\\.", " ") + " " + this.argumentParser.getUsage(source).toPlain();
    }

    public final Optional<Text> getChildrenUsage(CommandSource source) {
        HashSet primary = Sets.newHashSet((Iterable)this.dispatcher.getPrimaryAliases());
        primary.removeIf(x -> x.equalsIgnoreCase("?") || x.equalsIgnoreCase("help"));
        if (primary.isEmpty()) {
            return Optional.empty();
        }
        List s = primary.stream().filter(x -> ((CommandMapping)this.dispatcher.get(x).get()).getCallable().testPermission(source)).map(x -> {
            String toSuggest = "/" + this.getCommandPath().replaceAll("\\.", " ") + " " + x;
            return Text.builder((String)x).onClick((ClickAction)TextActions.suggestCommand((String)toSuggest)).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.usage.suggest", toSuggest))).onShiftClick((ShiftClickAction)TextActions.insertText((String)(toSuggest + " ?"))).color(TextColors.AQUA).build();
        }).collect(Collectors.toList());
        if (s.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Text.joinWith((Text)Text.of((String)", "), s));
    }

    protected CommandElement[] getArguments() {
        return new CommandElement[0];
    }

    final CommentedConfigurationNode getDefaults() {
        SimpleCommentedConfigurationNode n = SimpleCommentedConfigurationNode.root();
        String aliasComment = NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.aliases", new String[0]);
        if (this.isRoot) {
            n.getNode(new Object[]{"enabled"}).setComment(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.enabled", new String[0])).setValue((Object)true);
            String[] al = this.getAliases();
            for (int i = 1; i < al.length; ++i) {
                n.getNode(new Object[]{"aliases"}).getNode(new Object[]{al[i]}).setValue((Object)true);
            }
        }
        if (this.generateConfigEntries) {
            if (!this.bypassCooldown) {
                n.getNode(new Object[]{"cooldown"}).setComment(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.cooldown", new String[0])).setValue((Object)0);
            }
            if (!this.bypassWarmup || this.generateWarmupAnyway) {
                n.getNode(new Object[]{"warmup"}).setComment(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.warmup", new String[0])).setValue((Object)0);
            }
            if (!this.bypassCost) {
                n.getNode(new Object[]{"cost"}).setComment(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.cost", new String[0])).setValue((Object)0);
            }
        }
        for (String alias : this.getRootCommandAliases()) {
            n.getNode(new Object[]{"aliases"}).getNode(new Object[]{alias}).setValue((Object)true);
        }
        if (n.getNode(new Object[]{"aliases"}).getValue() == null) {
            n.removeChild((Object)"aliases");
        } else {
            n.getNode(new Object[]{"aliases"}).setComment(aliasComment);
        }
        return n;
    }

    protected ContinueMode preProcessChecks(T source, CommandContext args) {
        return ContinueMode.CONTINUE;
    }

    private T checkSourceType(CommandSource source) throws CommandException {
        if (this.sourceTypePredicate.test(source)) {
            return (T)source;
        }
        if (this.sourceType.equals(Player.class) && !(source instanceof Player)) {
            throw this.getExceptionFromKey("command.playeronly", new String[0]);
        }
        if (this.sourceType.equals(ConsoleSource.class) && !(source instanceof ConsoleSource)) {
            throw this.getExceptionFromKey("command.consoleonly", new String[0]);
        }
        if (this.sourceType.equals(CommandBlockSource.class) && !(source instanceof CommandBlockSource)) {
            throw this.getExceptionFromKey("command.commandblockonly", new String[0]);
        }
        throw this.getExceptionFromKey("command.unknownsource", new String[0]);
    }

    private CommandException getExceptionFromKey(String key, String ... subs) {
        return new CommandException(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat(key, subs));
    }

    private ContinueMode runChecks(Player src, CommandContext args) {
        ContinueMode m = this.checkCooldown(src, args);
        if (!m.cont) {
            return m;
        }
        m = this.applyCost(src, args);
        if (!m.cont) {
            return m;
        }
        return this.setupWarmup(src, args);
    }

    protected final Optional<WorldProperties> getWorldProperties(CommandSource src, String argument, CommandContext args) {
        Optional pr = args.getOne(argument);
        if (pr.isPresent()) {
            return pr;
        }
        if (src instanceof Locatable) {
            return Optional.of(((Locatable)src).getWorld().getProperties());
        }
        return Optional.empty();
    }

    protected final WorldProperties getWorldPropertiesOrDefault(CommandSource src, String argument, CommandContext args) {
        Optional<WorldProperties> pr = this.getWorldProperties(src, argument, args);
        if (pr.isPresent()) {
            return pr.get();
        }
        src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.worldproperties.default", new String[0]));
        return (WorldProperties)Sponge.getServer().getDefaultWorld().get();
    }

    @Nonnull
    protected final WorldProperties getWorldFromUserOrArgs(CommandSource src, String argument, CommandContext args) throws ReturnMessageException {
        Optional owp = args.getOne(argument);
        if (owp.isPresent()) {
            return (WorldProperties)owp.get();
        }
        if (src instanceof Locatable) {
            return ((Locatable)src).getWorld().getProperties();
        }
        throw ReturnMessageException.fromKey("command.noworldconsole", new Object[0]);
    }

    protected final <U extends User> U getUserFromArgs(Class<U> clazz, CommandSource src, Text argument, CommandContext args) throws ReturnMessageException {
        return this.getUserFromArgs(clazz, src, argument.toPlain(), args, "command.playeronly");
    }

    protected final <U extends User> U getUserFromArgs(Class<U> clazz, CommandSource src, String argument, CommandContext args) throws ReturnMessageException {
        return this.getUserFromArgs(clazz, src, argument, args, "command.playeronly");
    }

    protected final <U extends User> U getUserFromArgs(Class<U> clazz, CommandSource src, String argument, CommandContext args, String failKey) throws ReturnMessageException {
        Optional opl = args.getOne(argument);
        if (opl.isPresent()) {
            return (U)((User)opl.get());
        }
        if (clazz.isInstance(src)) {
            return (U)((User)clazz.cast(src));
        }
        throw new ReturnMessageException(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat(failKey, new String[0]));
    }

    @Nonnull
    protected final CatalogType getCatalogTypeFromHandOrArgs(CommandSource src, String argument, CommandContext args) throws ReturnMessageException {
        Optional catalogTypeOptional = args.getOne(argument);
        if (catalogTypeOptional.isPresent()) {
            Optional state;
            CatalogType type = (CatalogType)catalogTypeOptional.get();
            if (type instanceof ItemType && (state = ItemStack.of((ItemType)((ItemType)type), (int)1).get(Keys.ITEM_BLOCKSTATE)).isPresent()) {
                return (CatalogType)state.get();
            }
            return type;
        }
        if (src instanceof Player) {
            return Util.getTypeFromItemInHand((Player)src).orElseThrow(() -> new ReturnMessageException(this.plugin.getMessageProvider().getTextMessageWithFormat("command.noneinhand", new String[0])));
        }
        throw new ReturnMessageException(this.plugin.getMessageProvider().getTextMessageWithFormat("command.noitemconsole", new String[0]));
    }

    protected int getWarmup(Player src) {
        if (this.permissions.testWarmupExempt((Subject)src)) {
            return 0;
        }
        return Util.getPositiveIntOptionFromSubject((Subject)src, this.warmupKey).orElseGet(() -> this.plugin.getCommandsConfig().getCommandNode(this.configSection).getNode(new Object[]{"warmup"}).getInt());
    }

    private ContinueMode setupWarmup(final Player src, final CommandContext args) {
        if (this.bypassWarmup) {
            return ContinueMode.CONTINUE;
        }
        int warmupTime = this.getWarmup(src);
        if (warmupTime <= 0) {
            return ContinueMode.CONTINUE;
        }
        final Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        Task.Builder tb = Sponge.getScheduler().createTaskBuilder().delay((long)warmupTime, TimeUnit.SECONDS).execute((Consumer)new CostCancellableTask(this.plugin, (CommandSource)src, this.getCost((CommandSource)src, args)){

            @Override
            public void accept(Task task) {
                src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.end", new String[0]));
                this.plugin.getWarmupManager().removeWarmup(src.getUniqueId());
                AbstractCommand.this.onExecute((CommandSource)src, args, cause);
            }
        }).name("Command Warmup - " + src.getName());
        if (this.isAsync) {
            tb.async();
        }
        this.plugin.getWarmupManager().addWarmup(src.getUniqueId(), tb.submit((Object)this.plugin));
        src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.start", Util.getTimeStringFromSeconds(warmupTime)));
        WarmupConfig wc = Nucleus.getNucleus().getWarmupConfig();
        if (wc.isOnMove() && wc.isOnCommand()) {
            src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.both", new String[0]));
        } else if (wc.isOnMove()) {
            src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.onMove", new String[0]));
        } else if (wc.isOnCommand()) {
            src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.onCommand", new String[0]));
        }
        return ContinueMode.STOP_SUCCESS;
    }

    private ContinueMode checkCooldown(Player src, CommandContext args) {
        this.cleanCooldowns();
        if (!this.bypassCooldown && !args.hasAny("nocooldown") && !this.permissions.testCooldownExempt((Subject)src) && this.cooldownStore.containsKey(src.getUniqueId())) {
            Instant l = this.cooldownStore.get(src.getUniqueId());
            src.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("cooldown.message", Util.getTimeStringFromSeconds(l.until(Instant.now(), ChronoUnit.SECONDS))));
            return ContinueMode.STOP;
        }
        return ContinueMode.CONTINUE;
    }

    private void setCooldown(Player src, CommandContext args) {
        if (!args.hasAny("nocooldown")) {
            this.setCooldown(src);
        }
    }

    public void setCooldown(Player player) {
        int cooldownTime;
        if (!this.permissions.testCooldownExempt((Subject)player) && (cooldownTime = Util.getPositiveIntOptionFromSubject((Subject)player, this.cooldownKey).orElseGet(() -> this.plugin.getCommandsConfig().getCommandNode(this.configSection).getNode(new Object[]{"cooldown"}).getInt()).intValue()) > 0) {
            this.cooldownStore.put(player.getUniqueId(), Instant.now().plus((long)cooldownTime, ChronoUnit.SECONDS));
        }
    }

    protected void removeCooldown(UUID uuid) {
        this.cooldownStore.remove(uuid);
    }

    private void cleanCooldowns() {
        this.cooldownStore.entrySet().removeIf(k -> ((Instant)k.getValue()).isBefore(Instant.now()));
    }

    private ContinueMode applyCost(Player src, CommandContext args) {
        double cost = this.getCost((CommandSource)src, args);
        if (cost == 0.0) {
            return ContinueMode.CONTINUE;
        }
        if (!this.plugin.getEconHelper().withdrawFromPlayer(src, cost)) {
            return ContinueMode.STOP;
        }
        return ContinueMode.CONTINUE;
    }

    protected double getCost(CommandSource src, @Nullable CommandContext args) {
        if (src instanceof Player) {
            boolean noCost;
            boolean bl = noCost = args != null && args.getOne("nocost").orElse(false) != false;
            if (this.bypassCost || noCost || this.permissions.testCostExempt((Subject)src)) {
                return 0.0;
            }
            String[] stringArray = new String[]{this.costKey};
            double cost = Util.getDoubleOptionFromSubject((Subject)src, stringArray).orElseGet(() -> this.plugin.getCommandsConfig().getCommandNode(this.configSection).getNode(new Object[]{"cost"}).getDouble(0.0));
            if (cost <= 0.0) {
                return 0.0;
            }
            return cost;
        }
        return 0.0;
    }

    private void createChildCommands() {
        Set<Class> bases = null;
        if (this.moduleCommands != null) {
            bases = this.moduleCommands.stream().filter(x -> {
                RegisterCommand r = x.getAnnotation(RegisterCommand.class);
                return r != null && r.subcommandOf().equals(this.getClass());
            }).collect(Collectors.toSet());
        }
        if (bases != null) {
            bases.forEach(cb -> {
                block2: {
                    try {
                        this.builder.buildCommand(cb, false).ifPresent(x -> this.dispatcher.register((CommandCallable)x, Arrays.asList(x.getAliases())));
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().error(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("command.child.notloaded", cb.getName()));
                        if (!Nucleus.getNucleus().isDebugMode()) break block2;
                        e.printStackTrace();
                    }
                }
            });
        }
        if (!this.getClass().isAnnotationPresent(NoHelpSubcommand.class)) {
            this.dispatcher.register((CommandCallable)this.usageCommand, new String[]{"?", "help"});
        }
    }

    void setModuleName(String id, String module) {
        if (this.module == null) {
            this.moduleId = id;
            this.module = module;
        }
    }

    public List<Text> getUsageText(CommandSource source) {
        try {
            return this.usageCommand.usage(source, null);
        }
        catch (CommandPermissionException e) {
            return Lists.newArrayList();
        }
    }

    @NonnullByDefault
    public static abstract class SimpleTargetOtherUser
    extends AbstractCommand<CommandSource> {
        protected CommandElement[] additionalArguments() {
            return new CommandElement[0];
        }

        @Override
        public final CommandElement[] getArguments() {
            Object[] additional = this.additionalArguments();
            if (additional.length == 0) {
                return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(new NoModifiersArgument<User>(NucleusParameters.ONE_USER, NoModifiersArgument.USER_NOT_CALLER_PREDICATE), this.permissions.getOthers()))};
            }
            return (CommandElement[])ArrayUtils.addAll((Object[])new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(new NoModifiersArgument<User>(NucleusParameters.ONE_USER, NoModifiersArgument.USER_NOT_CALLER_PREDICATE), this.permissions.getOthers()))}, (Object[])additional);
        }

        @Override
        protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
            User target = this.getUserFromArgs(User.class, src, "user", args);
            return this.executeWithPlayer(src, target, args, src instanceof Player && ((Player)src).getUniqueId().equals(target.getUniqueId()));
        }

        protected abstract CommandResult executeWithPlayer(CommandSource var1, User var2, CommandContext var3, boolean var4) throws Exception;
    }

    @NonnullByDefault
    public static abstract class SimpleTargetOtherPlayer
    extends AbstractCommand<CommandSource> {
        protected CommandElement[] additionalArguments() {
            return new CommandElement[0];
        }

        @Override
        public final CommandElement[] getArguments() {
            Object[] additional = this.additionalArguments();
            if (additional.length == 0) {
                return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(new NoModifiersArgument<Player>(NucleusParameters.ONE_PLAYER, NoModifiersArgument.PLAYER_NOT_CALLER_PREDICATE), this.permissions.getOthers()))};
            }
            return (CommandElement[])ArrayUtils.addAll((Object[])new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(new NoModifiersArgument<Player>(NucleusParameters.ONE_PLAYER, NoModifiersArgument.PLAYER_NOT_CALLER_PREDICATE), this.permissions.getOthers()))}, (Object[])additional);
        }

        @Override
        protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
            Player target = this.getUserFromArgs(Player.class, src, "player", args);
            return this.executeWithPlayer(src, target, args, src instanceof Player && ((Player)src).getUniqueId().equals(target.getUniqueId()));
        }

        protected abstract CommandResult executeWithPlayer(CommandSource var1, Player var2, CommandContext var3, boolean var4) throws Exception;
    }

    @NonnullByDefault
    private class UsageCommand
    implements CommandCallable,
    CommandExecutor {
        private UsageCommand() {
        }

        public CommandResult execute(CommandSource src, CommandContext args) {
            return this.process(src, "");
        }

        public CommandResult process(CommandSource source, String arguments) {
            return this.process(source, arguments, null);
        }

        CommandResult process(CommandSource source, String arguments, @Nullable String previous) {
            if (!this.testPermission(source)) {
                source.sendMessage(AbstractCommand.this.plugin.getMessageProvider().getTextMessageWithFormat("command.usage.nopermission", new String[0]));
                return CommandResult.empty();
            }
            try {
                List<Text> textMessages = this.usage(source, previous);
                String command = AbstractCommand.this.getCommandPath().replaceAll("\\.", " ");
                Text header = AbstractCommand.this.plugin.getMessageProvider().getTextMessageWithFormat("command.usage.header", command);
                PaginationService ps = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
                PaginationList.Builder builder = ps.builder().title(header).contents(textMessages);
                if (!(source instanceof Player)) {
                    builder.linesPerPage(-1);
                }
                builder.sendTo((MessageReceiver)source);
                return CommandResult.success();
            }
            catch (CommandPermissionException e) {
                source.sendMessage(AbstractCommand.this.plugin.getMessageProvider().getTextMessageWithFormat("command.usage.nopermission", new String[0]));
                return CommandResult.empty();
            }
        }

        public List<Text> usage(CommandSource source, @Nullable String previous) throws CommandPermissionException {
            String ext;
            if (!this.testPermission(source)) {
                throw new CommandPermissionException();
            }
            Nucleus plugin = Nucleus.getNucleus();
            AbstractCommand parent = AbstractCommand.this;
            ArrayList textMessages = Lists.newArrayList();
            if (previous != null) {
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.noexist", previous));
                textMessages.add(Util.SPACE);
            }
            if (parent.sourceType == Player.class) {
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.playeronly", new String[0]));
            }
            textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.module", AbstractCommand.this.module, AbstractCommand.this.moduleId));
            String desc = AbstractCommand.this.getDescription();
            if (!desc.isEmpty()) {
                textMessages.add(Util.SPACE);
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.summary", new String[0]));
                textMessages.add(Text.of((String)desc));
            }
            if (!(ext = AbstractCommand.this.getExtendedDescription()).isEmpty()) {
                String[] split;
                textMessages.add(Util.SPACE);
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.description", new String[0]));
                for (String s : split = ext.split("(\\r|\\n|\\r\\n)")) {
                    textMessages.add(Text.of((String)s));
                }
            }
            if (AbstractCommand.this.hasExecutor) {
                textMessages.add(Util.SPACE);
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.usage", new String[0]));
                textMessages.add(Text.of((Object[])new Object[]{TextColors.WHITE, AbstractCommand.this.getSimpleUsage(source)}));
            }
            AbstractCommand.this.getChildrenUsage(source).ifPresent(x -> {
                textMessages.add(Util.SPACE);
                textMessages.add(plugin.getMessageProvider().getTextMessageWithFormat("command.usage.subcommand", new String[0]));
                textMessages.add(Text.of((Object[])new Object[]{TextColors.WHITE, x}));
            });
            return textMessages;
        }

        public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) {
            return Lists.newArrayList();
        }

        public boolean testPermission(CommandSource source) {
            return AbstractCommand.this.permissions.testBase((Subject)source);
        }

        public Optional<Text> getShortDescription(CommandSource source) {
            return Optional.empty();
        }

        public Optional<Text> getHelp(CommandSource source) {
            return Optional.empty();
        }

        public Text getUsage(CommandSource source) {
            return Text.EMPTY;
        }
    }
}

