/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateMessageSender;
import io.github.nucleuspowered.nucleus.modules.admin.config.AdminConfig;
import io.github.nucleuspowered.nucleus.modules.admin.config.AdminConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.admin.config.BroadcastConfig;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@Permissions
@RegisterCommand(value={"broadcast", "bcast", "bc"})
@EssentialsEquivalent(value={"broadcast", "bcast"})
@NonnullByDefault
public class BroadcastCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private BroadcastConfig bc = new BroadcastConfig();

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        String m = (String)args.requireOne("message");
        Text p = this.bc.getPrefix().getForCommandSource(src);
        Text s = this.bc.getSuffix().getForCommandSource(src);
        NucleusTextTemplateImpl textTemplate = NucleusTextTemplateFactory.createFromAmpersandString(m, p, s);
        new NucleusTextTemplateMessageSender(textTemplate, src).send(cause);
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        this.bc = Nucleus.getNucleus().getConfigValue("admin", AdminConfigAdapter.class, AdminConfig::getBroadcastMessage).orElseGet(BroadcastConfig::new);
    }
}

