/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.commands;

import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.afk.commands.AFKCommand;
import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

@NoModifiers
@Permissions
@RegisterCommand(value={"afkkick", "kickafk"})
public class AFKKickCommand
extends AbstractCommand<CommandSource> {
    private final String permission = this.getPermissionHandlerFor(AFKCommand.class).getPermissionWithSuffix("exempt.kick");

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Optional<Text> reason = args.getOne("reason").map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0));
        Collection<Player> playersToKick = ((AFKHandler)this.getServiceUnchecked(AFKHandler.class)).getAfk(x -> !this.hasPermission((Subject)x, this.permission));
        if (playersToKick.isEmpty()) {
            this.sendMessageTo(src, "command.afkkick.nokick");
            return CommandResult.empty();
        }
        int number = playersToKick.size();
        playersToKick.forEach(x -> x.kick(reason.orElseGet(() -> this.getMessageFor(src.getLocale(), "afk.kickreason"))));
        this.sendMessageTo(src, "command.afkkick.success", new Object[]{number});
        return CommandResult.successCount((int)number);
    }
}

