/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.interceptors;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.modules.afk.config.AFKConfig;
import io.github.nucleuspowered.nucleus.modules.afk.config.AFKConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.afk.events.AFKEvents;
import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;

public class AFKCommandInterceptor
implements ICommandInterceptor,
Reloadable {
    private final AFKHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(AFKHandler.class);
    @Nullable
    private NucleusTextTemplate message = null;
    private boolean send = false;

    @Override
    public void onPreCommand(Class<? extends AbstractCommand<?>> commandClass, CommandSource source, CommandContext context) {
    }

    @Override
    public void onPostCommand(Class<? extends AbstractCommand<?>> commandClass, CommandSource source, CommandContext context, CommandResult result) {
        if (this.send && result.getSuccessCount().orElse(0) > 0 && commandClass.isAnnotationPresent(NotifyIfAFK.class)) {
            NotifyIfAFK annotation = commandClass.getAnnotation(NotifyIfAFK.class);
            Cause cause = CauseStackHelper.createCause(source);
            for (String key : annotation.value()) {
                context.getAll(key).stream().filter(x -> x instanceof User).map(x -> ((User)x).getPlayer().orElse(null)).filter(Objects::nonNull).filter(this.handler::isAFK).forEach(x -> {
                    Text messageToSend = this.message == null ? null : this.message.getForCommandSource((CommandSource)x);
                    AFKEvents.Notify event = new AFKEvents.Notify((Player)x, messageToSend, cause);
                    Sponge.getEventManager().post((Event)event);
                    event.getMessage().ifPresent(arg_0 -> ((CommandSource)source).sendMessage(arg_0));
                });
            }
        }
    }

    @Override
    public void onReload() {
        AFKConfig config = (AFKConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(AFKConfigAdapter.class).getNodeOrDefault();
        if (config.isAlertSenderOnAfk()) {
            NucleusTextTemplateImpl textTemplate = config.getMessages().getOnCommand();
            this.message = textTemplate == null || textTemplate.isEmpty() ? null : textTemplate;
            this.send = true;
        } else {
            this.message = null;
            this.send = false;
        }
    }
}

