/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.service.NucleusJailService;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.modules.back.commands.BackCommand;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfig;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.World;

public class BackListeners
implements Reloadable,
ListenerBase {
    public static final String ON_TELEPORT = "targets.teleport";
    public static final String ON_DEATH = "targets.death";
    public static final String ON_PORTAL = "targets.portal";
    private final BackHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(BackHandler.class);
    private BackConfig backConfig = new BackConfig();
    @Nullable
    private final NucleusJailService njs = NucleusAPI.getJailService().orElse(null);
    private CommandPermissionHandler s = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(BackCommand.class);

    @Override
    public void onReload() {
        this.backConfig = (BackConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(BackConfigAdapter.class).getNodeOrDefault();
    }

    @Listener
    @Exclude(value={MoveEntityEvent.Teleport.Portal.class})
    public void onTeleportPlayer(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player pl) {
        if (this.backConfig.isOnTeleport() && this.check(event) && this.getLogBack(pl) && this.s.testSuffix((Subject)pl, ON_TELEPORT)) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getFromTransform());
        }
    }

    @Listener
    public void onPortalPlayer(MoveEntityEvent.Teleport.Portal event, @Getter(value="getTargetEntity") Player pl) {
        if (this.backConfig.isOnPortal() && this.check((MoveEntityEvent.Teleport)event) && this.getLogBack(pl) && this.s.testSuffix((Subject)pl, ON_PORTAL)) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getFromTransform());
        }
    }

    @Listener
    public void onDeathEvent(DestructEntityEvent.Death event) {
        Living e = event.getTargetEntity();
        if (!(e instanceof Player)) {
            return;
        }
        Player pl = (Player)e;
        if (this.backConfig.isOnDeath() && this.getLogBack(pl) && this.s.testSuffix((Subject)pl, ON_DEATH)) {
            this.handler.setLastLocation((User)pl, (Transform<World>)event.getTargetEntity().getTransform());
        }
    }

    private boolean check(MoveEntityEvent.Teleport event) {
        return !event.getFromTransform().equals((Object)event.getToTransform());
    }

    private boolean getLogBack(Player player) {
        return (this.njs == null || !this.njs.isPlayerJailed((User)player)) && this.handler.isLoggingLastLocation((User)player);
    }
}

