/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.connectionmessages.listeners;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.events.NucleusFirstJoinEvent;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.connectionmessages.config.ConnectionMessagesConfig;
import io.github.nucleuspowered.nucleus.modules.connectionmessages.config.ConnectionMessagesConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;

public class ConnectionMessagesListener
implements Reloadable,
ListenerBase {
    private ConnectionMessagesConfig cmc = new ConnectionMessagesConfig();
    private final String disablePermission = "nucleus.connectionmessages.disable";

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("nucleus.connectionmessages.disable", new PermissionInformation(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("permission.connectionmesssages.disable", new String[0]), SuggestedLevel.NONE));
            }
        };
    }

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join joinEvent, @Getter(value="getTargetEntity") Player pl) {
        block8: {
            if (joinEvent.isMessageCancelled() || this.cmc.isDisableWithPermission() && this.hasPermission((Subject)pl, this.disablePermission)) {
                joinEvent.setMessageCancelled(true);
                return;
            }
            try {
                ModularUserService nucleusUser = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)pl);
                Optional<String> lastKnown = nucleusUser.get(CoreUserDataModule.class).getLastKnownName();
                if (this.cmc.isDisplayPriorName() && !this.cmc.getPriorNameMessage().isEmpty()) {
                    if (!lastKnown.orElseGet(() -> ((Player)pl).getName()).equalsIgnoreCase(pl.getName())) {
                        joinEvent.getChannel().orElse(MessageChannel.TO_ALL).send((Object)Nucleus.getNucleus(), this.cmc.getPriorNameMessage().getForCommandSource((CommandSource)pl, (Map<String, Function<CommandSource, Optional<Text>>>)ImmutableMap.of((Object)"previousname", cs -> Optional.of(Text.of((String)((String)lastKnown.get())))), Maps.newHashMap()));
                    }
                }
            }
            catch (Exception e) {
                if (!Nucleus.getNucleus().isDebugMode()) break block8;
                e.printStackTrace();
            }
        }
        if (this.cmc.isModifyLoginMessage()) {
            if (this.cmc.getLoginMessage().isEmpty()) {
                joinEvent.setMessageCancelled(true);
            } else {
                joinEvent.setMessage((TextRepresentable)this.cmc.getLoginMessage().getForCommandSource((CommandSource)pl));
            }
        }
    }

    @Listener
    public void onPlayerFirstJoin(NucleusFirstJoinEvent event, @Getter(value="getTargetEntity") Player pl) {
        if (this.cmc.isShowFirstTimeMessage() && !this.cmc.getFirstTimeMessage().isEmpty()) {
            event.getChannel().orElse(MessageChannel.TO_ALL).send((Object)Nucleus.getNucleus(), this.cmc.getFirstTimeMessage().getForCommandSource((CommandSource)pl));
        }
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect leaveEvent, @Getter(value="getTargetEntity") Player pl) {
        if (leaveEvent.isMessageCancelled() || this.cmc.isDisableWithPermission() && this.hasPermission((Subject)pl, this.disablePermission)) {
            leaveEvent.setMessageCancelled(true);
            return;
        }
        if (this.cmc.isModifyLogoutMessage()) {
            if (this.cmc.getLogoutMessage().isEmpty()) {
                leaveEvent.setMessageCancelled(true);
            } else {
                leaveEvent.setMessage((TextRepresentable)this.cmc.getLogoutMessage().getForCommandSource((CommandSource)pl));
            }
        }
    }

    @Override
    public void onReload() {
        this.cmc = (ConnectionMessagesConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ConnectionMessagesConfigAdapter.class).getNodeOrDefault();
    }
}

