/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.listeners;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.UniqueUserCountTransientModule;
import io.github.nucleuspowered.nucleus.modules.core.events.NucleusOnLoginEvent;
import io.github.nucleuspowered.nucleus.modules.core.events.OnFirstLoginEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CoreListener
implements Reloadable,
ListenerBase {
    @Nullable
    private NucleusTextTemplate getKickOnStopMessage = null;
    @Nullable
    private final URL url;
    private boolean warnOnWildcard = true;

    public CoreListener() {
        URL u = null;
        try {
            u = new URL("https://ore.spongepowered.org/Nucleus/Nucleus/pages/The-Permissions-Wildcard-(And-Why-You-Shouldn't-Use-It)");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.url = u;
    }

    @Listener(order=Order.LATE)
    public void onPlayerLoginLast(ClientConnectionEvent.Login event, @Getter(value="getProfile") GameProfile profile, @Getter(value="getTargetUser") User user) {
        Nucleus.getNucleus().getUserDataManager().get(profile.getUniqueId()).ifPresent(qsu -> {
            if (event.getFromTransform().equals((Object)event.getToTransform())) {
                CoreUserDataModule c = qsu.get(CoreUserDataModule.class);
                NucleusOnLoginEvent onLoginEvent = CauseStackHelper.createFrameWithCausesWithReturn(cause -> new NucleusOnLoginEvent((Cause)cause, user, (ModularUserService)qsu, (Transform<World>)event.getFromTransform()), profile);
                Sponge.getEventManager().post((Event)onLoginEvent);
                if (onLoginEvent.getTo().isPresent()) {
                    event.setToTransform(onLoginEvent.getTo().get());
                    c.removeLocationOnLogin();
                    return;
                }
                Optional<Location<World>> olw = c.getLocationOnLogin();
                olw.ifPresent(worldLocation -> {
                    event.setToTransform(event.getFromTransform().setLocation(worldLocation));
                    c.removeLocationOnLogin();
                });
            }
            Nucleus.getNucleus().getUserCacheService().updateCacheForPlayer((ModularUserService)qsu);
        });
    }

    @Listener(order=Order.FIRST)
    public void onPlayerJoinFirst(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        try {
            ModularUserService qsu = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)player);
            CoreUserDataModule c = qsu.get(CoreUserDataModule.class);
            c.setLastLogin(Instant.now());
            if (Nucleus.getNucleus().isServer()) {
                c.setLastIp(player.getConnection().getAddress().getAddress());
            }
            String name = player.getName();
            Task.builder().execute(() -> c.setLastKnownName(name)).delayTicks(20L).submit((Object)Nucleus.getNucleus());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Listener
    public void onPlayerJoinLast(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        ModularUserService qsu = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)player);
        CoreUserDataModule c = qsu.get(CoreUserDataModule.class);
        if (!c.getFirstJoin().isPresent()) {
            Nucleus.getNucleus().getGeneralService().getTransient(UniqueUserCountTransientModule.class).resetUniqueUserCount();
            OnFirstLoginEvent firstJoinEvent = new OnFirstLoginEvent(event.getCause(), player, event.getOriginalChannel(), event.getChannel().orElse(null), event.getOriginalMessage(), event.isMessageCancelled(), event.getFormatter());
            Sponge.getEventManager().post((Event)firstJoinEvent);
            event.setChannel((MessageChannel)firstJoinEvent.getChannel().get());
            event.setMessageCancelled(firstJoinEvent.isMessageCancelled());
            c.setFirstJoin(c.getLastLogin().orElseGet(Instant::now));
        }
        if (!ServiceChangeListener.isOpOnly() && player.hasPermission("nucleus")) {
            MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
            Nucleus.getNucleus().getLogger().warn("The player " + player.getName() + " has got either the nucleus wildcard or the * wildcard permission. This may cause unintended side effects.");
            if (this.warnOnWildcard) {
                ArrayList text = Lists.newArrayList();
                text.add(provider.getTextMessageWithFormat("core.permission.wildcard2", new String[0]));
                text.add(provider.getTextMessageWithFormat("core.permission.wildcard3", new String[0]));
                if (this.url != null) {
                    text.add(provider.getTextMessageWithFormat("core.permission.wildcard4", new String[0]).toBuilder().onClick((ClickAction)TextActions.openUrl((URL)this.url)).build());
                }
                text.add(provider.getTextMessageWithFormat("core.permission.wildcard5", new String[0]));
                ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().title(provider.getTextMessageWithFormat("core.permission.wildcard", new String[0])).contents((Iterable)text).padding(Text.of((Object[])new Object[]{TextColors.GOLD, "-"})).sendTo((MessageReceiver)player);
            }
        }
    }

    @Listener(beforeModifications=true)
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player player) {
        if (player.getConnection() == null || player.getConnection().getAddress() == null) {
            return;
        }
        Nucleus.getNucleus().getUserDataManager().get((User)player).ifPresent(x -> this.onPlayerQuit((ModularUserService)x, player));
    }

    private void onPlayerQuit(ModularUserService x, Player player) {
        Location location = player.getLocation();
        InetAddress address = player.getConnection().getAddress().getAddress();
        try {
            CoreUserDataModule coreUserDataModule = x.get(CoreUserDataModule.class);
            coreUserDataModule.setLastIp(address);
            coreUserDataModule.setLastLogout((Location<World>)location);
            x.save();
            Nucleus.getNucleus().getUserCacheService().updateCacheForPlayer(x);
        }
        catch (Exception e) {
            Nucleus.getNucleus().printStackTraceIfDebugMode(e);
        }
    }

    @Override
    public void onReload() {
        CoreConfig c = (CoreConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault();
        this.getKickOnStopMessage = c.isKickOnStop() ? c.getKickOnStopMessage() : null;
        this.warnOnWildcard = c.isCheckForWildcard();
    }

    @Listener
    public void onServerAboutToStop(GameStoppingServerEvent event) {
        Nucleus.getNucleus().getUserDataManager().getOnlineUsers().forEach(x -> x.getPlayer().ifPresent(y -> this.onPlayerQuit((ModularUserService)x, (Player)y)));
        if (this.getKickOnStopMessage != null) {
            for (Player p : Sponge.getServer().getOnlinePlayers()) {
                Text msg = this.getKickOnStopMessage.getForCommandSource((CommandSource)p);
                if (msg.isEmpty()) {
                    p.kick();
                    continue;
                }
                p.kick(msg);
            }
        }
    }

    @Listener
    public void onGameReload(GameReloadEvent event) {
        CommandSource requester = (CommandSource)event.getCause().first(CommandSource.class).orElse(Sponge.getServer().getConsole());
        if (Nucleus.getNucleus().reload()) {
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "[Nucleus] ", Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reload.one", new String[0])}));
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "[Nucleus] ", Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reload.two", new String[0])}));
        } else {
            requester.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "[Nucleus] ", Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reload.errorone", new String[0])}));
        }
    }
}

