/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RegisterCommand(value={"hat", "head"})
@NoModifiers
@Permissions(supportsSelectors=true, supportsOthers=true)
@EssentialsEquivalent(value={"hat", "head"})
@NonnullByDefault
public class HatCommand
extends AbstractCommand.SimpleTargetOtherPlayer {
    @Override
    protected CommandResult executeWithPlayer(CommandSource player, Player pl, CommandContext args, boolean isSelf) throws Exception {
        Optional helmetOptional = pl.getHelmet();
        ItemStack stack = (ItemStack)pl.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> ReturnMessageException.fromKey("command.generalerror.handempty", new Object[0]));
        ItemStack hand = stack.copy();
        hand.setQuantity(1);
        pl.setHelmet(hand);
        Text itemName = hand.get(Keys.DISPLAY_NAME).orElseGet(() -> Text.of((Translatable)stack, (Object[])new Object[0]));
        GameMode gameMode = pl.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET);
        if (gameMode != GameModes.CREATIVE) {
            if (stack.getQuantity() > 1) {
                stack.setQuantity(stack.getQuantity() - 1);
                pl.setItemInHand(HandTypes.MAIN_HAND, stack);
            } else {
                pl.setItemInHand(HandTypes.MAIN_HAND, null);
            }
        }
        helmetOptional.ifPresent(itemStack -> Util.getStandardInventory((Carrier)pl).offer(itemStack.copy()).getRejectedItems().forEach(x -> Util.dropItemOnFloorAtLocation(x, pl.getWorld(), pl.getLocation().getPosition())));
        if (!isSelf) {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.hat.success", Nucleus.getNucleus().getNameUtil().getName((User)pl), itemName));
        }
        pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.hat.successself", itemName));
        return CommandResult.success();
    }
}

