/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveDoubleArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.explosion.Explosion;

@NonnullByDefault
@RegisterCommand(value={"rocket"})
@Permissions(supportsOthers=true, suggestedLevel=SuggestedLevel.ADMIN)
public class RocketCommand
extends AbstractCommand<CommandSource> {
    private final String velocity = "velocity";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"h", "-hard"}).flag(new String[]{"g", "-g"}).valueFlag((CommandElement)new PositiveDoubleArgument((Text)Text.of((String)this.velocity)), new String[]{"v", "-velocity"}).flag(new String[]{"s", "-silent"}).flag(new String[]{"e", "-explosion"}).buildWith(NucleusParameters.ONE_PLAYER)};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Player target = this.getUserFromArgs(Player.class, src, "player", args);
        boolean isSelf = target.equals(src);
        if (!isSelf && !this.permissions.testOthers((Subject)src)) {
            throw ReturnMessageException.fromKey("command.rocket.noothers", new Object[0]);
        }
        double v = 2.0;
        if (args.hasAny(this.velocity)) {
            v = (Double)args.getOne(this.velocity).get();
        } else if (args.hasAny("g")) {
            v = 0.5;
        } else if (args.hasAny("h")) {
            v = 4.0;
        }
        if (args.hasAny("e")) {
            Explosion ex = Explosion.builder().canCauseFire(false).location(target.getLocation()).shouldBreakBlocks(false).shouldPlaySmoke(true).shouldDamageEntities(false).radius((float)v * 2.0f).build();
            ex.getWorld().triggerExplosion(ex);
            Sponge.getScheduler().createSyncExecutor((Object)Nucleus.getNucleus()).schedule(() -> ex.getWorld().playSound(SoundTypes.ENTITY_FIREWORK_LAUNCH, target.getLocation().getPosition(), 2.0), 500L, TimeUnit.MILLISECONDS);
        }
        Vector3d velocity = new Vector3d(0.0, v, 0.0);
        target.offer(Keys.VELOCITY, (Object)velocity);
        if (!args.hasAny("s")) {
            target.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.rocket.self", new String[0]));
        }
        if (!isSelf) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.rocket.other", target.getName()));
        }
        return CommandResult.success();
    }
}

