/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.IfConditionElseArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.Since;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.inventory.listeners.InvSeeListener;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Permissions(supportsOthers=true)
@RegisterCommand(value={"enderchest", "ec", "echest"})
@Since(minecraftVersion="1.10.2", spongeApiVersion="5.0.0", nucleusVersion="0.13.0")
@EssentialsEquivalent(value={"enderchest", "echest", "endersee", "ec"})
public class EnderChestCommand
extends AbstractCommand<Player>
implements InternalServiceManagerTrait {
    private final String offlinePerm;
    private final CommandElement element;

    public EnderChestCommand() {
        this.offlinePerm = this.permissions.getPermissionWithSuffix("offline");
        this.element = new IfConditionElseArgument(NucleusParameters.ONE_USER_PLAYER_KEY, NucleusParameters.ONE_PLAYER, (source, context) -> this.hasPermission((Subject)source, this.offlinePerm));
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> mspi = super.permissionSuffixesToRegister();
        mspi.put("exempt.target", PermissionInformation.getWithTranslation("permission.enderchest.exempt.inspect", SuggestedLevel.ADMIN));
        mspi.put("exempt.interact", PermissionInformation.getWithTranslation("permission.enderchest.exempt.modify", SuggestedLevel.ADMIN));
        mspi.put("exempt.modify", PermissionInformation.getWithTranslation("permission.enderchest.exempt.modify", SuggestedLevel.ADMIN));
        mspi.put("modify", PermissionInformation.getWithTranslation("permission.enderchest.modify", SuggestedLevel.ADMIN));
        mspi.put("offline", PermissionInformation.getWithTranslation("permission.enderchest.offline", SuggestedLevel.ADMIN));
        return mspi;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(this.element, this.permissions.getPermissionWithSuffix("others")))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        User target = (User)args.getOne("player").orElse(src);
        if (!target.getUniqueId().equals(src.getUniqueId())) {
            if (this.permissions.testSuffix((Subject)target, "exempt.target")) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.enderchest.targetexempt", target.getName()));
            }
            Inventory ec = target.getEnderChestInventory();
            Container container = (Container)src.openInventory(ec).orElseThrow(() -> ReturnMessageException.fromKey("command.invsee.failed", new Object[0]));
            if (this.permissions.testSuffix((Subject)target, "exempt.modify") || this.permissions.testSuffix((Subject)target, "exempt.interact") || !this.permissions.testSuffix((Subject)src, "modify")) {
                InvSeeListener.addEntry(src.getUniqueId(), container);
            }
        } else {
            src.openInventory(src.getEnderChestInventory()).orElseThrow(() -> ReturnMessageException.fromKey("command.invsee.failed", new Object[0]));
        }
        return CommandResult.success();
    }
}

