/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.services;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.service.NucleusInvulnerabilityService;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.invulnerability.datamodules.InvulnerabilityUserDataModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusInvulnerabilityService.class)
@NonnullByDefault
public class InvulnerabilityService
implements NucleusInvulnerabilityService,
ContextCalculator<Subject>,
ServiceBase {
    private final Map<UUID, Boolean> invulnerabilityCache = new HashMap<UUID, Boolean>();
    private final Context context = new Context("nucleus-invulnerable", "true");

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        if (calculable instanceof Player && this.isInvulnerable((User)((Player)calculable))) {
            accumulator.add(this.context);
        }
    }

    public boolean matches(Context context, Subject calculable) {
        return this.context.equals((Object)context) && calculable instanceof Player && this.isInvulnerable((User)((Player)calculable));
    }

    @Override
    public boolean isInvulnerable(User user) {
        Optional op = user.getPlayer();
        if (op.isPresent()) {
            return this.invulnerabilityCache.computeIfAbsent(user.getUniqueId(), uuid -> Nucleus.getNucleus().getUserDataManager().get(user).map(x -> x.get(InvulnerabilityUserDataModule.class).isInvulnerable()).orElse(false));
        }
        return Nucleus.getNucleus().getUserDataManager().get(user).map(x -> x.get(InvulnerabilityUserDataModule.class).isInvulnerable()).orElse(false);
    }

    @Override
    public void setInvulnerable(User user, boolean invulnerable) throws NucleusException {
        ModularUserService mus = Nucleus.getNucleus().getUserDataManager().get(user).orElseThrow(() -> new NucleusException((Text)Text.of((String)"User does not have a data file available"), NucleusException.ExceptionType.DOES_NOT_EXIST));
        mus.get(InvulnerabilityUserDataModule.class).setInvulnerable(invulnerable);
        user.getPlayer().ifPresent(x -> this.invulnerabilityCache.put(user.getUniqueId(), invulnerable));
        if (!mus.save()) {
            throw new NucleusException((Text)Text.of((String)"Could not save data"), NucleusException.ExceptionType.UNKNOWN_ERROR);
        }
    }

    public void removeFromCache(UUID uuid) {
        this.invulnerabilityCache.remove(uuid);
    }
}

