/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.events.NucleusFirstJoinEvent;
import io.github.nucleuspowered.nucleus.api.exceptions.KitRedeemException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.dataservices.KitService;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitHandler;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;

public class KitListener
implements ListenerBase {
    private final UserDataManager loader = Nucleus.getNucleus().getUserDataManager();
    private final KitHandler handler = this.getServiceUnchecked(KitHandler.class);
    private final KitService gds = Nucleus.getNucleus().getKitService();

    @Listener
    public void onPlayerFirstJoin(NucleusFirstJoinEvent event, @Getter(value="getTargetEntity") Player player) {
        this.loader.get((User)player).ifPresent(p -> {
            for (Kit kit : this.gds.getFirstJoinKits()) {
                try {
                    this.handler.redeemKit(kit, player, true, true);
                }
                catch (KitRedeemException kitRedeemException) {}
            }
        });
    }

    @Listener
    @Exclude(value={InteractInventoryEvent.Open.class})
    public void onPlayerInteractInventory(InteractInventoryEvent event, @Root Player player, @Getter(value="getTargetInventory") Container inventory) {
        this.handler.getCurrentlyOpenInventoryKit(inventory).ifPresent(x -> {
            try {
                ((Kit)x.getFirst()).updateKitInventory((Inventory)x.getSecond());
                this.handler.saveKit((Kit)x.getFirst());
                if (event instanceof InteractInventoryEvent.Close) {
                    this.gds.save();
                    player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.edit.success", ((Kit)x.getFirst()).getName()));
                    this.handler.removeKitInventoryFromListener(inventory);
                }
            }
            catch (Exception e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.edit.error", ((Kit)x.getFirst()).getName()));
            }
        });
        if (this.handler.isViewer(inventory)) {
            if (event instanceof InteractInventoryEvent.Close) {
                this.handler.removeViewer(inventory);
            } else {
                event.setCancelled(true);
            }
        }
    }
}

