/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.internal.DataScanner;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.CommandFlags;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;

@Permissions
@RegisterCommand(value={"blockinfo"})
@RunAsync
@NonnullByDefault
public class BlockInfoCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().setUnknownShortFlagBehavior(CommandFlags.UnknownFlagBehavior.IGNORE).permissionFlag(this.permissions.getPermissionWithSuffix("extended"), new String[]{"e", "-extended"}).buildWith(NucleusParameters.OPTIONAL_LOCATION)};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("extended", PermissionInformation.getWithTranslation("permission.blockinfo.extended", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(CommandSource source, CommandContext args, Cause cause) throws Exception {
        Location loc = null;
        if (args.hasAny("location")) {
            loc = args.getOne("location").filter(x -> x.getBlockType() != BlockTypes.AIR).orElse(null);
        } else {
            if (!(source instanceof Player)) {
                throw ReturnMessageException.fromKey("command.blockinfo.player", new Object[0]);
            }
            BlockRay bl = BlockRay.from((Entity)((Player)source)).distanceLimit(10.0).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
            Optional ob = bl.end();
            if (ob.isPresent() && ((BlockRayHit)ob.get()).getLocation().getBlockType() != BlockTypes.AIR) {
                BlockRayHit brh = (BlockRayHit)ob.get();
                loc = brh.getLocation();
            }
        }
        if (loc != null) {
            BlockState b = loc.getBlock();
            BlockType it = b.getType();
            ArrayList<Text> lt = new ArrayList<Text>();
            lt.add(this.getMessageFor(source.getLocale(), "command.blockinfo.id", new String[]{it.getId(), it.getTranslation().get()}));
            lt.add(this.getMessageFor(source.getLocale(), "command.iteminfo.extendedid", new String[]{b.getId()}));
            if (args.hasAny("e") || args.hasAny("extended")) {
                Collection cb;
                Collection cp = b.getApplicableProperties();
                if (!cp.isEmpty()) {
                    cp.forEach(x -> {
                        if (x.getValue() != null) {
                            DataScanner.getText(source, "command.blockinfo.property.item", x.getKey().toString(), x.getValue()).ifPresent(lt::add);
                        }
                    });
                }
                if (!(cb = b.getTraits()).isEmpty()) {
                    cb.forEach(x -> b.getTraitValue(x).ifPresent(v -> DataScanner.getText(source, "command.blockinfo.traits.item", x.getName(), v).ifPresent(lt::add)));
                }
            }
            ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(this.getMessageFor(source.getLocale(), "command.blockinfo.list.header", new String[]{String.valueOf(loc.getBlockX()), String.valueOf(loc.getBlockY()), String.valueOf(loc.getBlockZ())})).sendTo((MessageReceiver)source);
            return CommandResult.success();
        }
        this.sendMessageTo(source, "command.blockinfo.none");
        return CommandResult.empty();
    }
}

