/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.services;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.NameUtil;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.exceptions.NicknameException;
import io.github.nucleuspowered.nucleus.api.service.NucleusNicknameService;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.nickname.commands.NicknameCommand;
import io.github.nucleuspowered.nucleus.modules.nickname.config.NicknameConfig;
import io.github.nucleuspowered.nucleus.modules.nickname.config.NicknameConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.nickname.datamodules.NicknameUserDataModule;
import io.github.nucleuspowered.nucleus.modules.nickname.events.ChangeNicknameEventPost;
import io.github.nucleuspowered.nucleus.modules.nickname.events.ChangeNicknameEventPre;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;

@APIService(value=NucleusNicknameService.class)
public class NicknameService
implements NucleusNicknameService,
Reloadable,
PermissionTrait,
ServiceBase {
    private Text prefix = Text.EMPTY;
    private Pattern pattern;
    private int min = 3;
    private int max = 16;
    private final Map<String[], Tuple<Matcher, Text>> replacements = Maps.newHashMap();
    private boolean registered = false;
    private final BiMap<UUID, String> cache = HashBiMap.create();
    private final BiMap<UUID, Text> textCache = HashBiMap.create();

    public void updateCache(UUID player, Text text) {
        this.cache.put((Object)player, (Object)text.toPlain());
        this.textCache.put((Object)player, (Object)text);
    }

    public Optional<Player> getFromCache(String text) {
        UUID u = (UUID)this.cache.inverse().get((Object)text);
        if (u != null) {
            Optional ret = Sponge.getServer().getPlayer(u);
            if (!ret.isPresent()) {
                this.cache.remove((Object)u);
            }
            return ret;
        }
        return Optional.empty();
    }

    public Map<String, UUID> getAllCached() {
        return Maps.newHashMap((Map)this.cache.inverse());
    }

    public Map<String, UUID> startsWithGetMap(String text) {
        return this.cache.inverse().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(text.toLowerCase())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<UUID> startsWith(String text) {
        return this.cache.inverse().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(text.toLowerCase())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void removeFromCache(UUID player) {
        this.cache.remove((Object)player);
        this.textCache.remove((Object)player);
    }

    public void register() {
        if (this.registered) {
            return;
        }
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        CommandPermissionHandler permissions = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(NicknameCommand.class);
        String colPerm = permissions.getPermissionWithSuffix("colour.");
        String colPerm2 = permissions.getPermissionWithSuffix("color.");
        NameUtil.getColours().forEach((key, value) -> this.replacements.put(new String[]{colPerm + value.getName(), colPerm2 + value.getName()}, (Tuple<Matcher, Text>)Tuple.of((Object)Pattern.compile("[&]+" + key.toString().toLowerCase(), 2).matcher(""), (Object)mp.getTextMessageWithFormat("command.nick.colour.nopermswith", value.getName()))));
        String stylePerm = permissions.getPermissionWithSuffix("style.");
        NameUtil.getStyleKeys().entrySet().stream().filter(x -> ((Character)x.getKey()).charValue() != 'k').forEach(k -> this.replacements.put(new String[]{stylePerm + ((String)k.getValue()).toLowerCase()}, (Tuple<Matcher, Text>)Tuple.of((Object)Pattern.compile("[&]+" + ((Character)k.getKey()).toString().toLowerCase(), 2).matcher(""), (Object)mp.getTextMessageWithFormat("command.nick.style.nopermswith", ((String)k.getValue()).toLowerCase()))));
        this.replacements.put(new String[]{permissions.getPermissionWithSuffix("magic")}, (Tuple<Matcher, Text>)Tuple.of((Object)Pattern.compile("[&]+k", 2).matcher(""), (Object)mp.getTextMessageWithFormat("command.nick.style.nopermswith", "magic")));
        this.registered = true;
    }

    @Override
    public Optional<Text> getNicknameWithPrefix(User user) {
        return this.getNickname(user).map(x -> Text.join((Text[])new Text[]{this.prefix, x}));
    }

    @Override
    public Optional<Text> getNickname(User user) {
        if (user.isOnline()) {
            return Optional.ofNullable(this.textCache.get((Object)user.getUniqueId()));
        }
        return Nucleus.getNucleus().getUserDataManager().get(user).map(x -> x.get(NicknameUserDataModule.class).getNicknameAsText().orElse(null));
    }

    @Override
    public void setNickname(User user, @Nullable Text nickname, boolean bypassRestrictions) throws NicknameException {
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        if (nickname != null) {
            this.setNick(user, cause, nickname, bypassRestrictions);
        } else {
            this.removeNick(user, cause);
        }
    }

    public void removeNick(User user, CommandSource src) throws NicknameException {
        this.removeNick(user, CauseStackHelper.createCause(src));
    }

    private void removeNick(User user, Cause cause) throws NicknameException {
        Text currentNickname = this.getNickname(user).orElse(null);
        if (!(user instanceof Player) && user.getPlayer().isPresent()) {
            user = (User)user.getPlayer().get();
        }
        ChangeNicknameEventPre cne = new ChangeNicknameEventPre(cause, currentNickname, null, user);
        if (Sponge.getEventManager().post((Event)cne)) {
            throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.eventcancel", user.getName()), NicknameException.Type.EVENT_CANCELLED);
        }
        ModularUserService mus = Nucleus.getNucleus().getUserDataManager().get(user).orElseThrow(() -> new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.error.nouser", new String[0]), NicknameException.Type.NO_USER));
        NicknameUserDataModule n = mus.get(NicknameUserDataModule.class);
        n.removeNickname();
        mus.set(n);
        mus.save();
        this.removeFromCache(user.getUniqueId());
        Sponge.getEventManager().post((Event)new ChangeNicknameEventPost(cause, currentNickname, null, user));
        if (user.isOnline()) {
            user.getPlayer().ifPresent(x -> x.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.delnick.success.base", new String[0])));
        }
    }

    public void setNick(User pl, CommandSource src, Text nickname, boolean bypass) throws NicknameException {
        this.setNick(pl, CauseStackHelper.createCause(src), nickname, bypass);
    }

    private void setNick(User pl, Cause cause, Text nickname, boolean bypass) throws NicknameException {
        String plain = nickname.toPlain().trim();
        if (plain.isEmpty()) {
            throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.tooshort", new String[0]), NicknameException.Type.TOO_SHORT);
        }
        try {
            Optional match = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(nickname.toPlain().trim());
            if (match.isPresent() && !((User)match.get()).getUniqueId().equals(pl.getUniqueId())) {
                throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.nameinuse", plain), NicknameException.Type.NOT_OWN_IGN);
            }
        }
        catch (IllegalArgumentException match) {
            // empty catch block
        }
        if (!(pl instanceof Player) && pl.getPlayer().isPresent()) {
            pl = (User)pl.getPlayer().get();
        }
        if (!bypass) {
            Optional os = cause.first(Subject.class);
            if (os.isPresent()) {
                this.stripPermissionless((Subject)os.get(), nickname);
            }
            if (!this.pattern.matcher(plain).matches()) {
                throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.nopattern", this.pattern.pattern()), NicknameException.Type.INVALID_PATTERN);
            }
            int strippedNameLength = plain.length();
            if (strippedNameLength < Math.max(this.min, 1)) {
                throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.tooshort", new String[0]), NicknameException.Type.TOO_SHORT);
            }
            if (strippedNameLength > Math.max(this.max, this.min)) {
                throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.toolong", new String[0]), NicknameException.Type.TOO_SHORT);
            }
        }
        Text currentNickname = this.getNickname(pl).orElse(null);
        ChangeNicknameEventPre cne = new ChangeNicknameEventPre(cause, currentNickname, nickname, pl);
        if (Sponge.getEventManager().post((Event)cne)) {
            throw new NicknameException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.eventcancel", pl.getName()), NicknameException.Type.EVENT_CANCELLED);
        }
        ModularUserService mus = Nucleus.getNucleus().getUserDataManager().getUnchecked(pl);
        NicknameUserDataModule nicknameUserDataModule = mus.get(NicknameUserDataModule.class);
        nicknameUserDataModule.setNickname(nickname);
        mus.set(nicknameUserDataModule);
        mus.save();
        Text set = nicknameUserDataModule.getNicknameAsText().get();
        this.updateCache(pl.getUniqueId(), nickname);
        Sponge.getEventManager().post((Event)new ChangeNicknameEventPost(cause, currentNickname, nickname, pl));
        pl.getPlayer().ifPresent(player -> player.sendMessage(Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.success.base", new String[0])}).append(new Text[]{Text.of((Object[])new Object[]{" - ", TextColors.RESET, set})}).build()));
    }

    @Override
    public void onReload() {
        NicknameConfig nc = (NicknameConfig)Nucleus.getNucleus().getConfigAdapter("nickname", NicknameConfigAdapter.class).get().getNodeOrDefault();
        this.pattern = nc.getPattern();
        this.min = nc.getMinNicknameLength();
        this.max = nc.getMaxNicknameLength();
        this.prefix = TextSerializers.FORMATTING_CODE.deserialize(nc.getPrefix());
    }

    private void stripPermissionless(Subject source, Text message) throws NicknameException {
        String m = TextSerializers.FORMATTING_CODE.serialize(message);
        if (m.contains("&")) {
            for (Map.Entry<String[], Tuple<Matcher, Text>> r : this.replacements.entrySet()) {
                if (!((Matcher)r.getValue().getFirst()).reset(m).find() || !Arrays.stream((Object[])r.getKey()).noneMatch(x -> this.hasPermission(source, (String)x))) continue;
                throw new NicknameException((Text)r.getValue().getSecond(), NicknameException.Type.INVALID_STYLE_OR_COLOUR);
            }
        }
    }

    public Text getNickPrefix() {
        return this.prefix;
    }
}

