/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.modules.serverlist.config.ServerListConfig;
import io.github.nucleuspowered.nucleus.modules.serverlist.config.ServerListConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.serverlist.datamodules.ServerListGeneralDataModule;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@RunAsync
@NonnullByDefault
@RegisterCommand(value={"serverlist", "sl"})
public class ServerListCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private ServerListConfig slc = new ServerListConfig();

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"m", "-messages"}).flag(new String[]{"w", "-whitelist"}).buildWith(GenericArguments.none())};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        if (args.hasAny("m")) {
            this.onMessage(src, this.slc.getMessages(), "command.serverlist.head.messages");
            return CommandResult.success();
        }
        if (args.hasAny("w")) {
            this.onMessage(src, this.slc.getWhitelist(), "command.serverlist.head.whitelist");
            return CommandResult.success();
        }
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        if (this.slc.isModifyServerList()) {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.modify.true", new String[0]));
            if (!this.slc.getMessages().isEmpty()) {
                src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.messages.click", new String[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -m")).toText());
            }
            if (!this.slc.getWhitelist().isEmpty()) {
                src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.whitelistmessages.click", new String[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -w")).toText());
            }
        } else if (this.slc.getModifyServerList() == ServerListConfig.ServerListSelection.WHITELIST) {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.modify.whitelist", new String[0]));
            if (!this.slc.getWhitelist().isEmpty()) {
                src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.whitelistmessages.click", new String[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -w")).toText());
            }
        } else {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.modify.false", new String[0]));
        }
        ServerListGeneralDataModule ss = Nucleus.getNucleus().getGeneralService().get(ServerListGeneralDataModule.class);
        ss.getMessage().ifPresent(t -> {
            src.sendMessage(Util.SPACE);
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.tempheader", new String[0]));
            src.sendMessage(t);
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.message.expiry", Util.getTimeToNow(ss.getExpiry().get())));
        });
        if (this.slc.isHidePlayerCount()) {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.hideplayers", new String[0]));
        } else if (this.slc.isHideVanishedPlayers()) {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.serverlist.hidevanished", new String[0]));
        }
        return CommandResult.success();
    }

    private void onMessage(CommandSource source, List<NucleusTextTemplateImpl> messages, String key) throws Exception {
        if (messages.isEmpty()) {
            throw ReturnMessageException.fromKey("command.serverlist.nomessages", new Object[0]);
        }
        ArrayList m = Lists.newArrayList();
        messages.stream().map(x -> x.getForCommandSource(source)).forEach(x -> {
            if (!m.isEmpty()) {
                m.add(Util.SPACE);
            }
            m.add(x);
        });
        Util.getPaginationBuilder(source).contents((Iterable)m).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(key, new String[0])).sendTo((MessageReceiver)source);
    }

    @Override
    public void onReload() {
        this.slc = (ServerListConfig)((ServerListConfigAdapter)this.getServiceUnchecked(ServerListConfigAdapter.class)).getNodeOrDefault();
    }
}

