/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.api.nucleusdata.WarpCategory;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpHandler;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="warp", suggestedLevel=SuggestedLevel.USER)
@RunAsync
@NonnullByDefault
@RegisterCommand(value={"list"}, subcommandOf=WarpCommand.class, rootAliasRegister={"warps"})
public class ListWarpCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final WarpHandler service = (WarpHandler)this.getServiceUnchecked(WarpHandler.class);
    private boolean isDescriptionInList = true;
    private double defaultCost = 0.0;
    private String defaultName = "unknown";
    private boolean isSeparatePerms = true;
    private boolean isCategorise = false;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"u"}).buildWith(GenericArguments.none())};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        if (this.service.getWarpNames().isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.list.nowarps", new String[0]));
            return CommandResult.empty();
        }
        return !args.hasAny("u") && this.isCategorise ? this.categories(src) : this.noCategories(src);
    }

    private boolean canView(CommandSource src, String warp) {
        return !this.isSeparatePerms || this.hasPermission((Subject)src, "nucleus.warps." + warp.toLowerCase());
    }

    private CommandResult categories(CommandSource src) {
        Map<WarpCategory, List<Warp>> warps = this.service.getWarpsWithCategories(x -> this.canView(src, x.getName()));
        this.createMain(src, warps);
        return CommandResult.success();
    }

    private void createMain(CommandSource src, Map<WarpCategory, List<Warp>> warps) {
        List lt = warps.keySet().stream().filter(Objects::nonNull).sorted(Comparator.comparing(WarpCategory::getId)).map(s -> {
            LiteralText.Builder t = Text.builder((String)"> ").color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).append(new Text[]{s.getDisplayName()}).onClick((ClickAction)TextActions.executeCallback(source -> this.createSub((CommandSource)source, (WarpCategory)s, warps)));
            s.getDescription().ifPresent(arg_0 -> ListWarpCommand.lambda$null$2((Text.Builder)t, arg_0));
            return t.build();
        }).collect(Collectors.toList());
        if (warps.containsKey(null)) {
            lt.add(Text.builder((String)("> " + this.defaultName)).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.executeCallback(source -> this.createSub((CommandSource)source, null, warps))).build());
        }
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        Util.getPaginationBuilder(src).header(messageProvider.getTextMessageWithFormat("command.warps.list.headercategory", new String[0])).title(messageProvider.getTextMessageWithFormat("command.warps.list.maincategory", new String[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)src);
    }

    private void createSub(CommandSource src, @Nullable WarpCategory category, Map<WarpCategory, List<Warp>> warpDataList) {
        boolean econExists = Nucleus.getNucleus().getEconHelper().economyServiceExists();
        Text name = category == null ? Text.of((String)this.defaultName) : category.getDisplayName();
        List lt = warpDataList.get(category).stream().sorted(Comparator.comparing(NamedLocation::getName)).map(s -> this.createWarp((Warp)s, s.getName(), econExists, this.defaultCost)).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.warps.list.category", name)).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).footer(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.list.back", new String[0]).toBuilder().onClick((ClickAction)TextActions.executeCallback(s -> this.createMain((CommandSource)s, warpDataList))).build()).sendTo((MessageReceiver)src);
    }

    private CommandResult noCategories(CommandSource src) {
        Set<String> ws = this.service.getWarpNames();
        boolean econExists = Nucleus.getNucleus().getEconHelper().economyServiceExists();
        List lt = ws.stream().filter(s -> this.canView(src, s.toLowerCase())).sorted(String::compareTo).map(s -> {
            Optional<Warp> wd = this.service.getWarp((String)s);
            return this.createWarp(wd.orElse(null), (String)s, econExists, this.defaultCost);
        }).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.list.header", new String[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents(lt).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createWarp(@Nullable Warp data, String name, boolean econExists, double defaultCost) {
        Text.Builder tb;
        if (data == null || !data.getLocation().isPresent()) {
            return Text.builder((String)name).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.unavailable", new String[0]))).build();
        }
        Location<World> world = data.getLocation().get();
        LiteralText.Builder inner = Text.builder((String)name).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.ITALIC}).onClick((ClickAction)TextActions.runCommand((String)("/warp \"" + name + "\"")));
        Optional<Text> description = data.getDescription();
        if (this.isDescriptionInList) {
            double cost;
            Text.Builder hoverBuilder = Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warpprompt", name)}).append(new Text[]{Text.NEW_LINE}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warplochover", ((World)world.getExtent()).getName(), world.getBlockPosition().toString())});
            if (econExists && (cost = data.getCost().orElse(defaultCost).doubleValue()) > 0.0) {
                hoverBuilder.append(new Text[]{Text.NEW_LINE}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.list.costhover", Nucleus.getNucleus().getEconHelper().getCurrencySymbol(cost))});
            }
            tb = Text.builder().append(new Text[]{inner.onHover((HoverAction)TextActions.showText((Text)hoverBuilder.build())).build()});
            description.ifPresent(text -> tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, " - "})}).append(new Text[]{text}));
        } else {
            double cost;
            if (description.isPresent()) {
                inner.onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warpprompt", name), Text.NEW_LINE, description.get()})));
            } else {
                inner.onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warpprompt", name)));
            }
            tb = Text.builder().append(new Text[]{inner.build()}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warploc", ((World)world.getExtent()).getName(), world.getBlockPosition().toString())});
            if (econExists && (cost = data.getCost().orElse(defaultCost).doubleValue()) > 0.0) {
                tb.append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.list.cost", Nucleus.getNucleus().getEconHelper().getCurrencySymbol(cost))});
            }
        }
        return tb.build();
    }

    @Override
    public void onReload() {
        WarpConfig warpConfig = (WarpConfig)((WarpConfigAdapter)this.getServiceUnchecked(WarpConfigAdapter.class)).getNodeOrDefault();
        this.defaultName = warpConfig.getDefaultName();
        this.defaultCost = warpConfig.getDefaultWarpCost();
        this.isDescriptionInList = warpConfig.isDescriptionInList();
        this.isCategorise = warpConfig.isCategoriseWarps();
        this.isSeparatePerms = warpConfig.isSeparatePermissions();
    }

    private static /* synthetic */ void lambda$null$2(Text.Builder t, Text x) {
        t.append(new Text[]{Text.of((String)" - ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.RESET, TextStyles.NONE, x})});
    }
}

