/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.argumentparsers.AdditionalCompletionsArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.NoModifiersArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.RequiredArgumentsArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCost;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ContinueMode;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.warp.WarpParameters;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.warp.event.UseWarpEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Permissions(suggestedLevel=SuggestedLevel.USER, supportsOthers=true)
@RegisterCommand(value={"warp"})
@NoCost
@EssentialsEquivalent(value={"warp", "warps"}, isExact=false, notes="Use '/warp' for warping, '/warps' to list warps.")
public class WarpCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private boolean isSafeTeleport = true;
    private double defaultCost = 0.0;

    @Override
    public void onReload() {
        WarpConfig wc = (WarpConfig)((WarpConfigAdapter)this.getServiceUnchecked(WarpConfigAdapter.class)).getNodeOrDefault();
        this.defaultCost = wc.getDefaultWarpCost();
        this.isSafeTeleport = wc.isSafeTeleport();
    }

    @Override
    protected Map<String, PermissionInformation> permissionsToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("nucleus.warps", PermissionInformation.getWithTranslation("permissions.warps", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.optionalWeak((CommandElement)GenericArguments.flags().flag(new String[]{"y", "a", "-accept"}).flag(new String[]{"f", "-force"}).setAnchorFlags(false).buildWith(GenericArguments.none()))), GenericArguments.optionalWeak((CommandElement)RequiredArgumentsArgument.r2(this.requirePermissionArg(new NoModifiersArgument<Player>(NucleusParameters.ONE_PLAYER, NoModifiersArgument.PLAYER_NOT_CALLER_PREDICATE), this.permissions.getOthers()))), GenericArguments.onlyOne((CommandElement)new AdditionalCompletionsArgument(WarpParameters.WARP_PERM, 0, 1, (c, s) -> this.permissions.testOthers((Subject)c) ? Sponge.getServer().getOnlinePlayers().stream().map(User::getName).collect(Collectors.toList()) : Lists.newArrayList()))};
    }

    @Override
    protected ContinueMode preProcessChecks(CommandSource source, CommandContext args) {
        if (args.getOne("player").map(x -> !(source instanceof Player) || x.getUniqueId().equals(((Player)source).getUniqueId())).orElse(false).booleanValue()) {
            args.putArg("nocooldown", (Object)true);
            return ContinueMode.CONTINUE;
        }
        if (!Nucleus.getNucleus().getEconHelper().economyServiceExists() || this.permissions.testCostExempt((Subject)source) || args.hasAny("y")) {
            return ContinueMode.CONTINUE;
        }
        Warp wd = (Warp)args.getOne("warp").get();
        Optional<Double> i = wd.getCost();
        double cost = i.orElse(this.defaultCost);
        if (cost <= 0.0) {
            return ContinueMode.CONTINUE;
        }
        String costWithUnit = Nucleus.getNucleus().getEconHelper().getCurrencySymbol(cost);
        if (Nucleus.getNucleus().getEconHelper().hasBalance((Player)source, cost)) {
            String command = String.format("/warp -y %s", wd.getName());
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.details", wd.getName(), costWithUnit));
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.clickaccept", new String[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)command)).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.clickhover", command))).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.alt", new String[0])}).build());
        } else {
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.nomoney", wd.getName(), costWithUnit));
        }
        return ContinueMode.STOP;
    }

    @Override
    public CommandResult executeCommand(CommandSource source, CommandContext args, Cause cause) throws Exception {
        Player player = this.getUserFromArgs(Player.class, source, "player", args);
        boolean isOther = !(source instanceof Player) || !((Player)source).getUniqueId().equals(player.getUniqueId());
        Warp wd = (Warp)args.getOne("warp").get();
        if (!wd.getTransform().isPresent()) {
            Sponge.getServer().loadWorld(wd.getWorldProperties().get().getUniqueId()).orElseThrow(() -> ReturnMessageException.fromKey("command.warp.worldnotloaded", new Object[0]));
        }
        UseWarpEvent event = CauseStackHelper.createFrameWithCausesWithReturn(c -> new UseWarpEvent((Cause)c, (User)player, wd), source);
        if (Sponge.getEventManager().post((Event)event)) {
            throw new ReturnMessageException(event.getCancelMessage().orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("nucleus.eventcancelled", new String[0])));
        }
        Optional<Double> i = wd.getCost();
        double cost = i.orElse(this.defaultCost);
        boolean charge = false;
        if (!isOther && Nucleus.getNucleus().getEconHelper().economyServiceExists() && !this.permissions.testCostExempt((Subject)source) && cost > 0.0) {
            if (Nucleus.getNucleus().getEconHelper().withdrawFromPlayer(player, cost, false)) {
                charge = true;
            } else {
                source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.nomoney", wd.getName(), Nucleus.getNucleus().getEconHelper().getCurrencySymbol(cost)));
                return CommandResult.empty();
            }
        }
        if (isOther) {
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.namedstart", Nucleus.getNucleus().getNameUtil().getSerialisedName((User)player), wd.getName()));
        } else {
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.start", wd.getName()));
        }
        boolean isSafe = !args.getOne("f").isPresent() && this.isSafeTeleport;
        NucleusTeleportHandler.TeleportResult result = Nucleus.getNucleus().getTeleportHandler().teleportPlayer(player, wd.getLocation().get(), wd.getRotation(), isSafe);
        if (!result.isSuccess()) {
            if (charge) {
                Nucleus.getNucleus().getEconHelper().depositInPlayer((User)player, cost, false);
            }
            throw ReturnMessageException.fromKey(result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION ? "command.warps.nosafe" : "command.warps.cancelled", new Object[0]);
        }
        if (isOther) {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warps.warped", wd.getName()));
        } else if (charge) {
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warp.cost.charged", Nucleus.getNucleus().getEconHelper().getCurrencySymbol(cost)));
        }
        return CommandResult.success();
    }
}

