/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.border;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.world.commands.border.BorderCommand;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world.border")
@NoModifiers
@RegisterCommand(value={"set"}, subcommandOf=BorderCommand.class)
@NonnullByDefault
public class SetBorderCommand
extends AbstractCommand<CommandSource> {
    private final String xKey = "x";
    private final String zKey = "z";
    private final String diameter = "diameter";
    private final String delayKey = "delay";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.seq((CommandElement[])new CommandElement[]{NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ALL, GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)this.xKey))), GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)this.zKey))), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.diameter))), GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.delayKey)))))}), GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.diameter))), GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.delayKey)))))})})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        int z;
        int x;
        WorldProperties wp = this.getWorldFromUserOrArgs(src, "world", args);
        int dia = (Integer)args.getOne(this.diameter).get();
        int delay = args.getOne(this.delayKey).orElse(0);
        if (src instanceof Locatable) {
            Location lw = ((Locatable)src).getLocation();
            if (args.hasAny(this.zKey)) {
                x = (Integer)args.getOne(this.xKey).get();
                z = (Integer)args.getOne(this.zKey).get();
            } else {
                x = lw.getBlockX();
                z = lw.getBlockZ();
            }
        } else {
            x = (Integer)args.getOne(this.xKey).get();
            z = (Integer)args.getOne(this.zKey).get();
        }
        wp.setWorldBorderCenter((double)x, (double)z);
        Optional world = Sponge.getServer().getWorld(wp.getUniqueId());
        world.ifPresent(w -> w.getWorldBorder().setCenter((double)x, (double)z));
        wp.setWorldBorderCenter((double)x, (double)z);
        if (delay == 0) {
            world.ifPresent(w -> w.getWorldBorder().setDiameter((double)dia));
            wp.setWorldBorderDiameter((double)dia);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.setborder.set", wp.getWorldName(), String.valueOf(x), String.valueOf(z), String.valueOf(dia)));
        } else {
            world.ifPresent(w -> w.getWorldBorder().setDiameter((double)dia, (long)delay * 1000L));
            wp.setWorldBorderTimeRemaining((long)delay * 1000L);
            wp.setWorldBorderTargetDiameter((double)dia);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.setborder.setdelay", wp.getWorldName(), String.valueOf(x), String.valueOf(z), String.valueOf(dia), String.valueOf(delay)));
        }
        return CommandResult.success();
    }
}

