/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder;

import com.google.inject.Inject;
import io.github.aquerr.worldrebuilder.commands.ActiveCommand;
import io.github.aquerr.worldrebuilder.commands.CreateRegionCommand;
import io.github.aquerr.worldrebuilder.commands.DeleteRegionCommand;
import io.github.aquerr.worldrebuilder.commands.HelpCommand;
import io.github.aquerr.worldrebuilder.commands.InfoCommand;
import io.github.aquerr.worldrebuilder.commands.ListCommand;
import io.github.aquerr.worldrebuilder.commands.RestoreTimeCommand;
import io.github.aquerr.worldrebuilder.commands.WandCommand;
import io.github.aquerr.worldrebuilder.commands.args.RegionArgument;
import io.github.aquerr.worldrebuilder.entity.SelectionPoints;
import io.github.aquerr.worldrebuilder.listener.BlockBreakListener;
import io.github.aquerr.worldrebuilder.listener.EntityDestroyListener;
import io.github.aquerr.worldrebuilder.listener.WandUsageListener;
import io.github.aquerr.worldrebuilder.managers.RegionManager;
import io.github.aquerr.worldrebuilder.scheduling.WorldRebuilderScheduler;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="worldrebuilder", name="Worldrebuilder", version="0.2.0", description="Rebuilds blocks that have been previously destroyed.", authors={"Aquerr"})
public class WorldRebuilder {
    public static final String VERSION = "0.2.0";
    public static final Text PLUGIN_ERROR = Text.of((Object[])new Object[]{TextColors.RED, "[WR] "});
    public static final Text PLUGIN_PREFIX = Text.of((Object[])new Object[]{TextColors.GREEN, "[WR] "});
    private final Map<List<String>, CommandCallable> subcommands = new HashMap<List<String>, CommandCallable>();
    private final Map<UUID, SelectionPoints> playerSelectionPoints = new HashMap<UUID, SelectionPoints>();
    @Inject
    private Logger logger;
    private static WorldRebuilder INSTANCE;
    private final CommandManager commandManager;
    private final EventManager eventManager;
    private final Path configDir;
    private final WorldRebuilderScheduler worldRebuilderScheduler;
    private final RegionManager regionManager;

    @Inject
    public WorldRebuilder(CommandManager commandManager, EventManager eventManager, RegionManager regionManager, WorldRebuilderScheduler worldRebuilderScheduler, @ConfigDir(sharedRoot=false) Path configDir) {
        INSTANCE = this;
        this.commandManager = commandManager;
        this.eventManager = eventManager;
        this.configDir = configDir;
        this.regionManager = regionManager;
        this.worldRebuilderScheduler = worldRebuilderScheduler;
    }

    public static WorldRebuilder getPlugin() {
        return INSTANCE;
    }

    @Listener
    public void onInit(GameInitializationEvent event) {
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PLUGIN_PREFIX, TextColors.YELLOW, "Initializing WorldRebuilder..."}));
        this.registerCommands();
        this.registerListeners();
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PLUGIN_PREFIX, TextColors.GREEN, "Loading completed. Plugin is ready to use!"}));
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public Map<UUID, SelectionPoints> getPlayerSelectionPoints() {
        return this.playerSelectionPoints;
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public WorldRebuilderScheduler getWorldRebuilderScheduler() {
        return this.worldRebuilderScheduler;
    }

    public Map<List<String>, CommandCallable> getSubcommands() {
        return this.subcommands;
    }

    private void registerCommands() {
        this.subcommands.put(Collections.singletonList("help"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Shows all available commands")).permission("worldrebuilder.player.command.help").executor((CommandExecutor)new HelpCommand(this)).arguments(GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"page")))).build());
        this.subcommands.put(Collections.singletonList("wand"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Gives WorldRebuilder wand")).permission("worldrebuilder.player.command.wand").executor((CommandExecutor)new WandCommand(this)).build());
        this.subcommands.put(Collections.singletonList("list"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Shows a list of all regions")).permission("worldrebuilder.player.command.list").executor((CommandExecutor)new ListCommand(this)).build());
        this.subcommands.put(Collections.singletonList("createregion"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Creates a region from selected points")).permission("worldrebuilder.player.command.createregion").executor((CommandExecutor)new CreateRegionCommand(this)).arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"name")))).build());
        this.subcommands.put(Collections.singletonList("deleteregion"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Deletes a region")).permission("worldrebuilder.player.command.deleteregion").executor((CommandExecutor)new DeleteRegionCommand(this)).arguments(GenericArguments.onlyOne((CommandElement)new RegionArgument(this, (Text)Text.of((String)"region")))).build());
        CommandSpec regionCommand = CommandSpec.builder().description((Text)Text.of((String)"Shows information about the region")).permission("worldrebuilder.player.command.region.info").executor((CommandExecutor)new InfoCommand(this)).build();
        CommandSpec restoreTimeCommand = CommandSpec.builder().description((Text)Text.of((String)"Sets region restore time")).permission("worldrebuilder.player.command.region.restoretime").executor((CommandExecutor)new RestoreTimeCommand(this)).arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)"timeInSeconds")))).build();
        CommandSpec activeCommand = CommandSpec.builder().description((Text)Text.of((String)"Activates/Deactivates a region")).permission("worldrebuilder.player.command.region.active").executor((CommandExecutor)new ActiveCommand(this)).arguments(GenericArguments.onlyOne((CommandElement)GenericArguments.bool((Text)Text.of((String)"isActive")))).build();
        this.subcommands.put(Collections.singletonList("region"), (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Region commands")).permission("worldrebuilder.player.command.region").arguments(GenericArguments.onlyOne((CommandElement)new RegionArgument(this, (Text)Text.of((String)"region")))).child((CommandCallable)regionCommand, new String[]{"info"}).child((CommandCallable)restoreTimeCommand, new String[]{"restoretime"}).child((CommandCallable)activeCommand, new String[]{"active"}).build());
        CommandSpec wrCommand = CommandSpec.builder().children(this.subcommands).build();
        this.commandManager.register((Object)this, (CommandCallable)wrCommand, new String[]{"worldrebuilder", "wr"});
    }

    private void registerListeners() {
        this.eventManager.registerListeners((Object)this, (Object)new WandUsageListener(this));
        this.eventManager.registerListeners((Object)this, (Object)new BlockBreakListener(this));
        this.eventManager.registerListeners((Object)this, (Object)new EntityDestroyListener(this));
    }
}

