/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.commands;

import io.github.aquerr.worldrebuilder.WorldRebuilder;
import io.github.aquerr.worldrebuilder.commands.WRCommand;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class WandCommand
extends WRCommand {
    public WandCommand(WorldRebuilder plugin) {
        super(plugin);
    }

    public CommandResult execute(CommandSource source, CommandContext args) throws CommandException {
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{WorldRebuilder.PLUGIN_ERROR, TextColors.RED, "Only in-game players can use this command!"}));
        }
        Player player = (Player)source;
        CarriedInventory inventory = player.getInventory();
        ArrayList<Text> wandDescriptionLines = new ArrayList<Text>();
        Text firstLine = Text.of((Object[])new Object[]{"Select first point with your", TextColors.GOLD, " left click."});
        Text secondLine = Text.of((Object[])new Object[]{"Select second point with your", TextColors.GOLD, " right click."});
        wandDescriptionLines.add(firstLine);
        wandDescriptionLines.add(secondLine);
        ItemStack worldRebuilderWand = ItemStack.builder().itemType(ItemTypes.IRON_AXE).quantity(1).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, "WorldRebuilder Wand"})).add(Keys.ITEM_LORE, wandDescriptionLines).build();
        inventory.offer(worldRebuilderWand);
        return CommandResult.success();
    }
}

