/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.worldrebuilder.scheduling;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RebuildEntityTask
implements Runnable {
    private final UUID worldUUID;
    private final EntitySnapshot entitySnapshot;

    public RebuildEntityTask(UUID worldUUID, EntitySnapshot entitySnapshot) {
        this.worldUUID = worldUUID;
        this.entitySnapshot = entitySnapshot;
    }

    @Override
    public void run() {
        Optional optionalWorld = Sponge.getServer().getWorld(this.worldUUID);
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Optional optionalEntity = this.entitySnapshot.restore();
        if (!optionalEntity.isPresent()) {
            return;
        }
        Entity newEntity = world.createEntity(this.entitySnapshot.getType(), ((Location)this.entitySnapshot.getLocation().get()).getPosition());
        world.spawnEntity(newEntity);
    }
}

