/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import pw.aaron1011.rentableregions.command.RentableRegionsCommand;
import pw.aaron1011.rentableregions.data.RentedRegion;

public class RemoveCommand
implements CommandExecutor {
    public static CommandSpec create() {
        return CommandSpec.builder().description((Text)Text.of((String)"Removes a player from a region")).arguments(new CommandElement[]{RentableRegionsCommand.getOwnRegionElement(), GenericArguments.user((Text)Text.of((String)"player"))}).permission("rentableregions.command.remove").executor((CommandExecutor)new RemoveCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to run this command!"}));
            return CommandResult.empty();
        }
        RentedRegion region = (RentedRegion)args.getOne((Text)Text.of((String)"region")).get();
        User user = (User)args.getOne((Text)Text.of((String)"player")).get();
        if (!region.addedPlayers.contains(user.getUniqueId())) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Player " + user.getName() + " is not a member of this region!"}));
            return CommandResult.empty();
        }
        region.removeMember(user.getUniqueId(), true);
        user.getPlayer().ifPresent(p -> p.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You were removed as a member of region " + region.name})));
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Player " + user.getName() + " was removed as a member of region " + region.name}));
        return CommandResult.success();
    }
}

